/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.AttributeUtils;
import com.everydayxp.rpgseteffects.util.SetTooltipHelper;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class BloodFurySet {
    private static final Set<Item> PIECES = Set.of((Item)ModItems.BLOOD_FURY_EMBLEM.get(), (Item)ModItems.BLOOD_FURY_AURA.get(), (Item)ModItems.BLOOD_FURY_BARRIER.get(), (Item)ModItems.BLOOD_FURY_ALLY.get());

    public static void apply(ServerPlayer player) {
        int count = BloodFurySet.getEquippedCount((Player)player);
        if (count == 0) {
            BloodFurySet.removeModifiers((Player)player);
            return;
        }
        BloodFurySet.removeModifiers((Player)player);
        if (count >= 1) {
            BloodFurySet.applyMaxHealthSafe(player, 4.0, SetUUIDs.BLOOD_FURY_HEALTH_1, "blood_fury_health_1");
        }
        if (count >= 2) {
            BloodFurySet.applyAttackDamageFlat((Player)player, 2.0);
        }
        if (count >= 3) {
            BloodFurySet.applyMaxHealthSafe(player, 4.0, SetUUIDs.BLOOD_FURY_HEALTH_2, "blood_fury_health_2");
        }
        if (count == 4) {
            BloodFurySet.applyAttackSpeed((Player)player, 0.15);
        }
    }

    public static List<Component> getTooltipLines() {
        Player player = SetTooltipHelper.getClientPlayer();
        int count = player != null ? BloodFurySet.getEquippedCount(player) : 0;
        List<SetTooltipHelper.BonusLine> bonuses = List.of(new SetTooltipHelper.BonusLine(1, "set.blood_fury.bonus.1"), new SetTooltipHelper.BonusLine(2, "set.blood_fury.bonus.2"), new SetTooltipHelper.BonusLine(3, "set.blood_fury.bonus.3"), new SetTooltipHelper.BonusLine(4, "set.blood_fury.bonus.4"));
        return SetTooltipHelper.generate("set.blood_fury.name", count, bonuses);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.contains(stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<Item> getPieces() {
        return PIECES;
    }

    private static void applyAttackDamageFlat(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.BLOOD_FURY_DAMAGE, "blood_fury_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyAttackSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.BLOOD_FURY_SPEED, "blood_fury_attack_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyMaxHealthSafe(ServerPlayer player, double amount, UUID uuid, String name) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22276_);
        if (attr != null) {
            attr.m_22120_(uuid);
            attr.m_22118_(new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.ADDITION));
            float current = player.m_21223_();
            float max = player.m_21233_();
            player.m_21153_(Math.min(current, max));
        }
    }

    private static void removeModifiers(Player player) {
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.BLOOD_FURY_HEALTH_1);
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.BLOOD_FURY_HEALTH_2);
        AttributeUtils.removeModifier(player, Attributes.f_22281_, SetUUIDs.BLOOD_FURY_DAMAGE);
        AttributeUtils.removeModifier(player, Attributes.f_22283_, SetUUIDs.BLOOD_FURY_SPEED);
    }
}

