/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.effects;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ArrowRainCustomEffect {
    private static final Map<UUID, ArrowRainInstance> rains = new HashMap<UUID, ArrowRainInstance>();

    public static void start(ServerPlayer player, LivingEntity target, int durationTicks, int area, int arrowsPerTick) {
        ArrowRainCustomEffect.stop(player);
        ArrowRainInstance inst = new ArrowRainInstance(player, target.m_20183_(), durationTicks, area, arrowsPerTick);
        rains.put(player.m_20148_(), inst);
    }

    public static void stop(ServerPlayer player) {
        ArrowRainInstance inst = rains.remove(player.m_20148_());
        if (inst != null) {
            inst.active = false;
        }
    }

    public static void tick(ServerLevel level) {
        Iterator<Map.Entry<UUID, ArrowRainInstance>> it = rains.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, ArrowRainInstance> entry = it.next();
            ArrowRainInstance inst = entry.getValue();
            if (!inst.active || !inst.player.m_6084_() || inst.ticks++ > inst.duration) {
                it.remove();
                continue;
            }
            for (int i = 0; i < inst.arrowsPerTick; ++i) {
                ArrowRainCustomEffect.spawnArrow(level, inst.center, (Player)inst.player, inst.area, inst.rand);
            }
        }
    }

    private static void spawnArrow(ServerLevel level, BlockPos pos, Player owner, int area, RandomSource rand) {
        double angle = rand.m_188500_() * Math.PI * 2.0;
        double rDist = rand.m_188500_() * (double)area;
        double dx = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * rDist;
        double dz = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * rDist;
        double y = pos.m_123342_() + 8;
        double searchRadius = area;
        Monster closest = null;
        double closestDist = Double.MAX_VALUE;
        for (Monster entity : level.m_45976_(Monster.class, new AABB(dx - searchRadius, y - searchRadius, dz - searchRadius, dx + searchRadius, y + searchRadius, dz + searchRadius))) {
            double dist;
            if (!entity.m_6084_() || !((dist = entity.m_20275_(dx, entity.m_20186_(), dz)) < closestDist)) continue;
            closestDist = dist;
            closest = entity;
        }
        Arrow arrow = new Arrow((Level)level, dx, y, dz);
        if (closest != null) {
            double tx = closest.m_20185_() - dx;
            double ty = closest.m_20186_() + (double)closest.m_20206_() * 0.5 - y;
            double tz = closest.m_20189_() - dz;
            double velocity = 1.5;
            arrow.m_6686_(tx, ty, tz, (float)velocity, 3.0f);
        } else {
            arrow.m_20334_(0.0, -1.0, 0.0);
        }
        arrow.m_36781_(2.0);
        arrow.m_36762_(true);
        arrow.m_5602_((Entity)owner);
        arrow.m_20049_("moonpiercer_rain");
        arrow.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        level.m_7967_((Entity)arrow);
    }

    static class ArrowRainInstance {
        final ServerPlayer player;
        final BlockPos center;
        final RandomSource rand;
        final int duration;
        final int area;
        final int arrowsPerTick;
        int ticks = 0;
        boolean active = true;

        ArrowRainInstance(ServerPlayer player, BlockPos pos, int duration, int area, int arrowsPerTick) {
            this.player = player;
            this.center = pos;
            this.rand = player.m_9236_().m_213780_();
            this.duration = duration;
            this.area = area;
            this.arrowsPerTick = arrowsPerTick;
        }
    }
}

