/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;

public class InfernoManager {
    private static final Map<UUID, Integer> orbs = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> cooldown = new HashMap<UUID, Long>();

    public static int getMaxOrbs(int effectLevel) {
        return Math.min(3, Math.max(1, effectLevel));
    }

    public static int getActiveOrbs(ServerPlayer player) {
        return orbs.getOrDefault(player.m_20148_(), 0);
    }

    public static void tick(ServerPlayer player, int effectLevel) {
        UUID id = player.m_20148_();
        int max = InfernoManager.getMaxOrbs(effectLevel);
        int current = orbs.getOrDefault(id, 0);
        long lastGen = cooldown.getOrDefault(id, 0L);
        long now = player.m_9236_().m_46467_();
        if (current < max && now - lastGen >= 100L) {
            orbs.put(id, current + 1);
            cooldown.put(id, now);
        }
    }

    public static boolean consume(ServerPlayer player) {
        UUID id = player.m_20148_();
        int current = orbs.getOrDefault(id, 0);
        if (current > 0) {
            orbs.put(id, current - 1);
            return true;
        }
        return false;
    }

    public static void clear(ServerPlayer player) {
        UUID id = player.m_20148_();
        orbs.remove(id);
        cooldown.remove(id);
    }
}

