/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.effects;

import com.everydayxp.rpgseteffects.registry.ModEffects;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PetMasteryEffect
extends MobEffect {
    public static final UUID PET_MASTERY_UUID = UUID.fromString("f0771170-9d8a-4bdb-b9bd-81b6d8ded7e5");

    public PetMasteryEffect() {
        super(MobEffectCategory.BENEFICIAL, 14139894);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        ServerPlayer serverPlayer = player = event.player instanceof ServerPlayer ? (ServerPlayer)event.player : null;
        if (player == null || player.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (player.m_21023_((MobEffect)ModEffects.PET_MASTERY.get())) {
            if (player.f_19797_ % 20 != 0) {
                return;
            }
            int petCount = PetMasteryEffect.getPetCount(player);
            int cappedCount = Math.min(petCount, 10);
            double bonusPercent = (double)cappedCount * 0.05;
            if (attr != null) {
                attr.m_22120_(PET_MASTERY_UUID);
                if (bonusPercent > 0.0) {
                    AttributeModifier mod = new AttributeModifier(PET_MASTERY_UUID, "pet_mastery_bonus_damage", bonusPercent, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    attr.m_22118_(mod);
                }
            }
        } else if (attr != null) {
            attr.m_22120_(PET_MASTERY_UUID);
        }
    }

    private static int getPetCount(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        List pets = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(96.0), e -> PetMasteryEffect.isOwnedBy(e, player));
        return pets.size();
    }

    private static boolean isOwnedBy(LivingEntity entity, ServerPlayer owner) {
        try {
            if (entity instanceof TamableAnimal) {
                TamableAnimal ta = (TamableAnimal)entity;
                return ta.m_269323_() == owner;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

