/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class AltharionSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.ALTHARION_AMULET, ModItems.ALTHARION_BELT, ModItems.ALTHARION_BODY, ModItems.ALTHARION_BOOTS, ModItems.ALTHARION_HELM, ModItems.ALTHARION_RELIC));
    private static final double LIFESTEAL_AMOUNT = 0.05;
    private static final double HEALING_RECEIVED_AMOUNT = 0.3;
    private static final double AOE_HEALING_AMOUNT = 1.0;
    private static final double GOLDEN_GUARD_AMOUNT = 1.0;
    private static final UUID ALTHARION_LIFESTEAL_UUID = UUID.fromString("ef1a2a07-bd10-4d7d-882d-c7e658530b42");
    private static final UUID ALTHARION_HEALING_UUID = UUID.fromString("1e6472c6-6e11-4df7-bc42-029b61c2b434");
    private static final UUID ALTHARION_AOE_UUID = UUID.fromString("5dcc2ac8-4f81-4f65-b47f-048584d92b23");
    private static final UUID ALTHARION_GOLDEN_UUID = UUID.fromString("526d02a3-2837-49b8-bfe1-efb8e90d8b12");

    public static void apply(ServerPlayer player) {
        Attribute healingReceived;
        Attribute lifeSteal;
        int count = AltharionSet.getEquippedCount((Player)player);
        AltharionSet.removeModifiers(player);
        if (count >= 2 && (lifeSteal = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "life_steal"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, lifeSteal, ALTHARION_LIFESTEAL_UUID, 0.05, "altharion_life_steal", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 4 && (healingReceived = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "healing_received"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, healingReceived, ALTHARION_HEALING_UUID, 0.3, "altharion_healing_received", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 6) {
            Attribute goldenGuard;
            Attribute aoeHealing = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aoe_healing"));
            if (aoeHealing != null) {
                RPGAttributeHelper.applyPlayerModifier(player, aoeHealing, ALTHARION_AOE_UUID, 1.0, "altharion_aoe_healing", AttributeModifier.Operation.ADDITION);
            }
            if ((goldenGuard = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "golden_guard"))) != null) {
                RPGAttributeHelper.applyPlayerModifier(player, goldenGuard, ALTHARION_GOLDEN_UUID, 1.0, "altharion_golden_guard", AttributeModifier.Operation.ADDITION);
            }
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        Attribute lifeSteal = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "life_steal"));
        Attribute healingReceived = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "healing_received"));
        Attribute aoeHealing = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aoe_healing"));
        Attribute goldenGuard = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "golden_guard"));
        ArrayList<List> bonuses = new ArrayList<List>(Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(lifeSteal, 0.05, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(healingReceived, 0.3, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(aoeHealing, 1.0, false), new SetTooltipBuilder.AttributeEntry(goldenGuard, 1.0, false))));
        return (stack, count) -> SetTooltipBuilder.build("set.altharion", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute lifeSteal = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "life_steal"));
        Attribute healingReceived = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "healing_received"));
        Attribute aoeHealing = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aoe_healing"));
        Attribute goldenGuard = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "golden_guard"));
        if (lifeSteal != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, lifeSteal, ALTHARION_LIFESTEAL_UUID);
        }
        if (healingReceived != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, healingReceived, ALTHARION_HEALING_UUID);
        }
        if (aoeHealing != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, aoeHealing, ALTHARION_AOE_UUID);
        }
        if (goldenGuard != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, goldenGuard, ALTHARION_GOLDEN_UUID);
        }
    }
}

