/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModEffects;
import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class HellbrandSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.HELLBRAND_AMULET, ModItems.HELLBRAND_BELT, ModItems.HELLBRAND_BODY, ModItems.HELLBRAND_BOOTS, ModItems.HELLBRAND_HELM, ModItems.HELLBRAND_RELIC));
    private static final double CRIT_CHANCE_AMOUNT = 0.25;
    private static final UUID HELLBRAND_CRIT_CHANCE_UUID = UUID.fromString("6fbe9db8-859f-4bc0-8141-466fd59cc273");
    private static final Map<UUID, Map<UUID, Integer>> HITS_MAP = new HashMap<UUID, Map<UUID, Integer>>();

    public static void apply(ServerPlayer player) {
        Attribute critChance;
        int count = HellbrandSet.getEquippedCount((Player)player);
        HellbrandSet.removeModifiers(player);
        if (count >= 2 && (critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, critChance, HELLBRAND_CRIT_CHANCE_UUID, 0.25, "hellbrand_crit_chance", AttributeModifier.Operation.ADDITION);
        }
        if (count < 6) {
            HITS_MAP.remove(player.m_20148_());
        }
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"));
        if (critChance != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, critChance, HELLBRAND_CRIT_CHANCE_UUID);
        }
        HITS_MAP.remove(player.m_20148_());
    }

    public static void applySetEffectOnHit(LivingEntity target, ServerPlayer player) {
        int count = HellbrandSet.getEquippedCount((Player)player);
        if (count >= 6) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.ARMOR_BREAK_III.get(), 40, 0, false, true, true));
        } else if (count >= 4) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.ARMOR_BREAK_II.get(), 40, 0, false, true, true));
        } else if (count >= 2) {
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.ARMOR_BREAK_I.get(), 40, 0, false, true, true));
        }
    }

    public static float getBonusDamage(ServerPlayer player, LivingEntity target, float baseDamage) {
        if (HellbrandSet.getEquippedCount((Player)player) < 6) {
            return baseDamage;
        }
        UUID attackerUUID = player.m_20148_();
        UUID victimUUID = target.m_20148_();
        Map hitMap = HITS_MAP.computeIfAbsent(attackerUUID, k -> new HashMap());
        int hits = hitMap.getOrDefault(victimUUID, 0) + 1;
        hitMap.put(victimUUID, hits);
        if (hits >= 7) {
            hitMap.put(victimUUID, 0);
            return baseDamage * 1.5f;
        }
        return baseDamage;
    }

    public static void resetHits(ServerPlayer player, LivingEntity target) {
        UUID attacker = player.m_20148_();
        UUID victim = target.m_20148_();
        Map<UUID, Integer> hitMap = HITS_MAP.get(attacker);
        if (hitMap != null) {
            hitMap.remove(victim);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        Attribute critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"));
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        List<Object> bonuses = Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(critChance, 0.25, true), new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.ARMOR_BREAK_I.get(), 0)), null, List.of(new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.ARMOR_BREAK_II.get(), 0)), null, List.of(new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.ARMOR_BREAK_III.get(), 0), Component.m_237115_((String)"set.hellbrand.bonus.combo").m_130940_(ChatFormatting.DARK_RED)));
        return (stack, count) -> SetTooltipBuilder.build("set.hellbrand", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }
}

