/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.effects.ArrowFanCustomEffect;
import com.everydayxp.rpgseteffects.effects.ArrowRainCustomEffect;
import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class MoonpiercerSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.MOONPIERCER_AMULET, ModItems.MOONPIERCER_BELT, ModItems.MOONPIERCER_BODY, ModItems.MOONPIERCER_BOOTS, ModItems.MOONPIERCER_HELM, ModItems.MOONPIERCER_RELIC));
    private static final double ARROW_PERCENT_BONUS_AMOUNT = 1.0;
    private static final double DRAW_SPEED_AMOUNT = 4.0;
    private static final UUID MOONPIERCER_ARROW_PERCENT_BONUS_UUID = UUID.fromString("cca86018-4bbe-4b98-9e79-73b7b9e60e30");
    private static final UUID MOONPIERCER_DRAW_SPEED_UUID = UUID.fromString("8c3927c6-2e25-41d6-b008-403d679e4696");

    public static void apply(ServerPlayer player) {
        Attribute drawSpeed;
        Attribute arrowPercentBonus;
        int count = MoonpiercerSet.getEquippedCount((Player)player);
        MoonpiercerSet.removeModifiers(player);
        if (count >= 2 && (arrowPercentBonus = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "arrow_percent_bonus"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, arrowPercentBonus, MOONPIERCER_ARROW_PERCENT_BONUS_UUID, 1.0, "moonpiercer_arrow_percent_bonus", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 4 && (drawSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "draw_speed"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, drawSpeed, MOONPIERCER_DRAW_SPEED_UUID, 4.0, "moonpiercer_draw_speed", AttributeModifier.Operation.ADDITION);
        }
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute arrowPercentBonus = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "arrow_percent_bonus"));
        Attribute drawSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "draw_speed"));
        if (arrowPercentBonus != null && player.m_21051_(arrowPercentBonus) != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, arrowPercentBonus, MOONPIERCER_ARROW_PERCENT_BONUS_UUID);
        }
        if (drawSpeed != null && player.m_21051_(drawSpeed) != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, drawSpeed, MOONPIERCER_DRAW_SPEED_UUID);
        }
    }

    public static void tryRainOfArrows(ServerPlayer player, LivingEntity target) {
        if (MoonpiercerSet.getEquippedCount((Player)player) < 6) {
            ArrowRainCustomEffect.stop(player);
            return;
        }
        ItemStack weapon = player.m_21205_();
        if (weapon.m_150930_(Items.f_42411_)) {
            ArrowRainCustomEffect.start(player, target, 60, 8, 10);
        } else if (weapon.m_150930_(Items.f_42717_)) {
            ArrowFanCustomEffect.start(player, 7, 1.8f);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        Attribute arrowPercentBonus = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "arrow_percent_bonus"));
        Attribute drawSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "draw_speed"));
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        ArrayList<List> bonuses = new ArrayList<List>(Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(arrowPercentBonus, 1.0, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(drawSpeed, 4.0, true)), null, List.of(Component.m_237115_((String)"set.moonpiercer.bonus.arrow_rain").m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)"set.moonpiercer.bonus.arrow_fan").m_130940_(ChatFormatting.AQUA))));
        return (stack, count) -> SetTooltipBuilder.build("set.moonpiercer", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }
}

