/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class ShadowHunterSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.SHADOW_HUNTER_AMULET, ModItems.SHADOW_HUNTER_BELT, ModItems.SHADOW_HUNTER_BODY, ModItems.SHADOW_HUNTER_BOOTS, ModItems.SHADOW_HUNTER_HELM, ModItems.SHADOW_HUNTER_RELIC));
    private static final double EXTRA_JUMPS_AMOUNT = 5.0;
    private static final double MOVE_SPEED_AMOUNT = 0.2;
    private static final double DODGE_CHANCE_AMOUNT = 0.25;
    private static final UUID SHADOW_EXTRA_JUMPS_UUID = UUID.fromString("c1a2b3c4-d5e6-7890-abcd-ef1234567890");
    private static final UUID SHADOW_MOVE_SPEED_UUID = UUID.fromString("abcdef12-3456-7890-abcd-1234567890ef");
    private static final UUID SHADOW_DODGE_UUID = UUID.fromString("12345678-90ab-cdef-1234-567890abcdef");

    public static void apply(ServerPlayer player) {
        Attribute dodgeChance;
        int count = ShadowHunterSet.getEquippedCount((Player)player);
        ShadowHunterSet.removeModifiers(player);
        if (count >= 2) {
            Attribute extraJumps = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "extra_jumps"));
            if (extraJumps != null) {
                RPGAttributeHelper.applyPlayerModifier(player, extraJumps, SHADOW_EXTRA_JUMPS_UUID, 5.0, "shadowhunter_extra_jumps", AttributeModifier.Operation.ADDITION);
            }
            RPGAttributeHelper.applyPlayerModifier(player, Attributes.f_22279_, SHADOW_MOVE_SPEED_UUID, 0.2, "shadowhunter_move_speed", AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (count >= 4 && (dodgeChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "dodge_chance"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, dodgeChance, SHADOW_DODGE_UUID, 0.25, "shadowhunter_dodge_chance", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 6) {
            ShadowHunterSet.handleSprintInvisibility(player);
        } else {
            player.m_21195_(MobEffects.f_19609_);
        }
    }

    public static void handleSprintInvisibility(ServerPlayer player) {
        Level level;
        if (ShadowHunterSet.getEquippedCount((Player)player) < 6) {
            player.m_21195_(MobEffects.f_19609_);
            player.getPersistentData().m_128379_("shadow_invis", false);
            return;
        }
        boolean wasInvisible = player.getPersistentData().m_128471_("shadow_invis");
        boolean sprinting = player.m_20142_();
        boolean shouldBeInvisible = sprinting;
        if (shouldBeInvisible) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 40, 0, false, false, false));
        }
        if (shouldBeInvisible && !wasInvisible && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 20, 0.5, 0.5, 0.5, 0.01);
        }
        player.getPersistentData().m_128379_("shadow_invis", shouldBeInvisible);
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        Attribute extraJumps = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "extra_jumps"));
        Attribute dodgeChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "dodge_chance"));
        ArrayList<List> bonuses = new ArrayList<List>(Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(extraJumps, 5.0, false), new SetTooltipBuilder.AttributeEntry(Attributes.f_22279_, 0.2, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(dodgeChance, 0.25, true)), null, List.of(Component.m_237115_((String)"set.shadowhunter.bonus.sprint_invisibility").m_130940_(ChatFormatting.DARK_PURPLE))));
        return (stack, count) -> SetTooltipBuilder.build("set.shadowhunter", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute extraJumps = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "extra_jumps"));
        Attribute dodgeChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "dodge_chance"));
        if (extraJumps != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, extraJumps, SHADOW_EXTRA_JUMPS_UUID);
        }
        if (dodgeChance != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, dodgeChance, SHADOW_DODGE_UUID);
        }
        RPGAttributeHelper.removePlayerModifier((Player)player, Attributes.f_22279_, SHADOW_MOVE_SPEED_UUID);
        player.m_21195_(MobEffects.f_19609_);
    }
}

