/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModEffects;
import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class TestBonusSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.TEST_BONUS_AMULET, ModItems.TEST_BONUS_BELT, ModItems.TEST_BONUS_BODY, ModItems.TEST_BONUS_HELM));

    public static void apply(ServerPlayer player) {
        int count = TestBonusSet.getEquippedCount((Player)player);
        TestBonusSet.removeEffects(player);
        if (count >= 2) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.INFERNO.get(), Integer.MAX_VALUE, 0, false, false));
        } else {
            player.m_21195_((MobEffect)ModEffects.INFERNO.get());
        }
        if (count >= 4) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.INFERNO.get(), Integer.MAX_VALUE, 2, false, false));
        }
    }

    private static void removeEffects(ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.INFERNO.get());
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        List<Object> bonuses = Arrays.asList(null, List.of(new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.INFERNO.get())), null, List.of(new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.INFERNO.get())));
        return (stack, count) -> SetTooltipBuilder.build("set.test_bonus", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }
}

