/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModEffects;
import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class WolfheartSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.WOLFHEART_AMULET, ModItems.WOLFHEART_BELT, ModItems.WOLFHEART_BODY, ModItems.WOLFHEART_BOOTS, ModItems.WOLFHEART_HELM, ModItems.WOLFHEART_RELIC));
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("3ea85992-b390-48df-b0d1-8a98e60b1f15");
    private static final UUID PET_SPEED_UUID = UUID.fromString("d9bc4d08-2c8f-476e-9cf7-db7fd7c22c80");
    private static final UUID PET_DAMAGE_UUID = UUID.fromString("27265a93-0f38-4daf-9c03-ed49fa79e6b1");
    private static final UUID PET_RESISTANCE_UUID = UUID.fromString("176af6e2-7a06-4213-8179-3bb6e301f9c2");
    private static final double ATTACK_DAMAGE_AMOUNT = 0.1;
    private static final double PET_SPEED_AMOUNT = 0.15;
    private static final double PET_DAMAGE_AMOUNT = 1.0;
    private static final double PET_RESISTANCE_AMOUNT = 0.5;

    public static void apply(ServerPlayer player) {
        Attribute petSpeed;
        int count = WolfheartSet.getEquippedCount((Player)player);
        WolfheartSet.removeModifiers(player);
        if (count >= 2) {
            Attribute attackDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("minecraft", "generic.attack_damage"));
            if (attackDamage != null) {
                RPGAttributeHelper.applyPlayerModifier(player, attackDamage, ATTACK_DAMAGE_UUID, 0.1, "wolfheart_attack_damage", AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.PET_MASTERY.get(), Integer.MAX_VALUE, 0, false, false));
        } else {
            player.m_21195_((MobEffect)ModEffects.PET_MASTERY.get());
        }
        if (count >= 4 && (petSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_speed"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, petSpeed, PET_SPEED_UUID, 0.15, "wolfheart_pet_speed", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 6) {
            Attribute petResistance;
            Attribute petDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_damage"));
            if (petDamage != null) {
                RPGAttributeHelper.applyPlayerModifier(player, petDamage, PET_DAMAGE_UUID, 1.0, "wolfheart_pet_damage", AttributeModifier.Operation.ADDITION);
            }
            if ((petResistance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_resistance"))) != null) {
                RPGAttributeHelper.applyPlayerModifier(player, petResistance, PET_RESISTANCE_UUID, 0.5, "wolfheart_pet_resistance", AttributeModifier.Operation.ADDITION);
            }
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        Attribute attackDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("minecraft", "generic.attack_damage"));
        Attribute petSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_speed"));
        Attribute petDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_damage"));
        Attribute petResistance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_resistance"));
        List<Object> bonuses = Arrays.asList(null, attackDamage != null ? List.of(new SetTooltipBuilder.AttributeEntry(attackDamage, 0.1, true), new SetTooltipBuilder.EffectEntry((MobEffect)ModEffects.PET_MASTERY.get())) : List.of(), null, petSpeed != null ? List.of(new SetTooltipBuilder.AttributeEntry(petSpeed, 0.15, true)) : List.of(), null, Arrays.asList(petDamage != null ? new SetTooltipBuilder.AttributeEntry(petDamage, 1.0, true) : null, petResistance != null ? new SetTooltipBuilder.AttributeEntry(petResistance, 0.5, true) : null).stream().filter(Objects::nonNull).toList());
        return (stack, count) -> SetTooltipBuilder.build("set.wolfheart", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute attackDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("minecraft", "generic.attack_damage"));
        Attribute petSpeed = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_speed"));
        Attribute petDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_damage"));
        Attribute petResistance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "pet_resistance"));
        if (attackDamage != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, attackDamage, ATTACK_DAMAGE_UUID);
        }
        if (petSpeed != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, petSpeed, PET_SPEED_UUID);
        }
        if (petDamage != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, petDamage, PET_DAMAGE_UUID);
        }
        if (petResistance != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, petResistance, PET_RESISTANCE_UUID);
        }
        player.m_21195_((MobEffect)ModEffects.PET_MASTERY.get());
    }
}

