/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.system;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public class EffectCooldownManager {
    private static final Map<UUID, Map<String, Integer>> cooldowns = new HashMap<UUID, Map<String, Integer>>();

    public static boolean shouldApply(Player player, String effectId, int intervalTicks) {
        UUID id = player.m_20148_();
        Map playerCooldowns = cooldowns.computeIfAbsent(id, k -> new HashMap());
        int ticksLeft = playerCooldowns.getOrDefault(effectId, 0);
        if (ticksLeft <= 0) {
            playerCooldowns.put(effectId, intervalTicks);
            return true;
        }
        playerCooldowns.put(effectId, ticksLeft - 1);
        return false;
    }

    public static boolean wasApplied(Player player, String effectId) {
        UUID id = player.m_20148_();
        return cooldowns.containsKey(id) && cooldowns.get(id).containsKey(effectId);
    }

    public static void reset(Player player, String effectId, int intervalTicks) {
        cooldowns.computeIfAbsent(player.m_20148_(), k -> new HashMap()).put(effectId, intervalTicks);
    }

    public static void clear(Player player) {
        cooldowns.remove(player.m_20148_());
    }
}

