/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.system;

import com.everydayxp.rpgseteffects.effects.ArrowRainCustomEffect;
import com.everydayxp.rpgseteffects.system.PlayerHealthCache;
import com.everydayxp.rpgseteffects.system.SetEffectTicker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerTickHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        event.getServer().m_6846_().m_11314_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = player;
                SetEffectTicker.tick(sp);
            }
        });
        event.getServer().m_129785_().forEach(level -> ArrowRainCustomEffect.tick(level));
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            SetEffectTicker.clear(player);
            SetEffectTicker.forceApply(player);
            Float cached = PlayerHealthCache.retrieve(player.m_20148_());
            if (cached != null) {
                player.m_21153_(Math.min(cached.floatValue(), player.m_21233_()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            SetEffectTicker.clear(player);
            SetEffectTicker.forceApply(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayerHealthCache.store(player.m_20148_(), player.m_21223_());
        }
    }
}

