/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.system;

import com.everydayxp.rpgseteffects.registry.ModEffects;
import com.everydayxp.rpgseteffects.sets.AltharionSet;
import com.everydayxp.rpgseteffects.sets.BloodFurySet;
import com.everydayxp.rpgseteffects.sets.HellbrandSet;
import com.everydayxp.rpgseteffects.sets.IgnisphereSet;
import com.everydayxp.rpgseteffects.sets.MoonpiercerSet;
import com.everydayxp.rpgseteffects.sets.SanctumSet;
import com.everydayxp.rpgseteffects.sets.ShadowHunterSet;
import com.everydayxp.rpgseteffects.sets.TestBonusSet;
import com.everydayxp.rpgseteffects.sets.WolfheartSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class SetEffectTicker {
    private static final List<SetApplier> SETS = List.of(AltharionSet::apply, BloodFurySet::apply, ShadowHunterSet::apply, SanctumSet::apply, HellbrandSet::apply, WolfheartSet::apply, MoonpiercerSet::apply, IgnisphereSet::apply, TestBonusSet::apply);
    private static final Map<UUID, PlayerCache> CACHE = new ConcurrentHashMap<UUID, PlayerCache>();

    public static void tick(ServerPlayer player) {
        UUID id = player.m_20148_();
        PlayerCache cache = CACHE.computeIfAbsent(id, k -> new PlayerCache());
        SetEffectTicker.applyIfChanged(player, cache);
        if (WolfheartSet.getEquippedCount((Player)player) >= 2) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.PET_MASTERY.get(), Integer.MAX_VALUE, 0, false, false));
        } else {
            player.m_21195_((MobEffect)ModEffects.PET_MASTERY.get());
        }
        ShadowHunterSet.handleSprintInvisibility(player);
    }

    public static void forceApply(ServerPlayer player) {
        AltharionSet.apply(player);
        BloodFurySet.apply(player);
        ShadowHunterSet.apply(player);
        SanctumSet.apply(player);
        HellbrandSet.apply(player);
        WolfheartSet.apply(player);
        MoonpiercerSet.apply(player);
        IgnisphereSet.apply(player);
        TestBonusSet.apply(player);
        PlayerCache cache = CACHE.computeIfAbsent(player.m_20148_(), k -> new PlayerCache());
        cache.invalidateAll();
        SetEffectTicker.applyIfChanged(player, cache);
    }

    private static void applyIfChanged(ServerPlayer player, PlayerCache cache) {
        SetEffectTicker.checkAndApply(cache, player, "Altharion", cache.altharion, AltharionSet::getEquippedCount, AltharionSet::apply, value -> {
            cache.altharion = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "BloodFury", cache.bloodfury, BloodFurySet::getEquippedCount, BloodFurySet::apply, value -> {
            cache.bloodfury = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "ShadowHunter", cache.shadowhunter, ShadowHunterSet::getEquippedCount, ShadowHunterSet::apply, value -> {
            cache.shadowhunter = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "Sanctum", cache.sanctum, SanctumSet::getEquippedCount, SanctumSet::apply, value -> {
            cache.sanctum = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "Hellbrand", cache.hellbrand, HellbrandSet::getEquippedCount, HellbrandSet::apply, value -> {
            cache.hellbrand = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "Wolfheart", cache.wolfheart, WolfheartSet::getEquippedCount, WolfheartSet::apply, value -> {
            cache.wolfheart = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "Moonpiercer", cache.moonpiercer, MoonpiercerSet::getEquippedCount, MoonpiercerSet::apply, value -> {
            cache.moonpiercer = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "Ignisphere", cache.ignisphere, IgnisphereSet::getEquippedCount, IgnisphereSet::apply, value -> {
            cache.ignisphere = value;
        });
        SetEffectTicker.checkAndApply(cache, player, "TestBonus", cache.testbonus, TestBonusSet::getEquippedCount, TestBonusSet::apply, value -> {
            cache.testbonus = value;
        });
    }

    public static void clear(ServerPlayer player) {
        CACHE.remove(player.m_20148_());
    }

    private static void checkAndApply(PlayerCache cache, ServerPlayer player, String setName, int last, Function<ServerPlayer, Integer> countFun, Consumer<ServerPlayer> applyFun, IntConsumer updateFun) {
        int now = countFun.apply(player);
        if (now != last) {
            updateFun.accept(now);
            applyFun.accept(player);
        }
    }

    private static class PlayerCache {
        int altharion = -1;
        int bloodfury = -1;
        int shadowhunter = -1;
        int sanctum = -1;
        int hellbrand = -1;
        int wolfheart = -1;
        int moonpiercer = -1;
        int ignisphere = -1;
        int testbonus = -1;

        private PlayerCache() {
        }

        void invalidateAll() {
            this.ignisphere = -1;
            this.moonpiercer = -1;
            this.wolfheart = -1;
            this.hellbrand = -1;
            this.sanctum = -1;
            this.shadowhunter = -1;
            this.bloodfury = -1;
            this.altharion = -1;
        }
    }

    @FunctionalInterface
    public static interface SetApplier {
        public void apply(ServerPlayer var1);
    }
}

