/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.client.gui.overlay;

import com.everydayxp.rpgseteffects.config.SetOverlayConfig;
import com.everydayxp.rpgseteffects.system.SetStatusTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rpgseteffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SetStatusOverlay {
    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        SetOverlayConfig.syncFromConfig();
        if (!SetOverlayConfig.showIcons) {
            return;
        }
        Map<String, Integer> activeSets = SetStatusTracker.getActiveSetCounts((Player)player);
        if (activeSets.isEmpty()) {
            return;
        }
        int iconSize = 32;
        float scale = SetOverlayConfig.iconScale;
        int scaledSize = (int)((float)iconSize * scale);
        int spacing = SetOverlayConfig.iconSpacing;
        int totalWidth = SetOverlayConfig.verticalLayout ? scaledSize : activeSets.size() * spacing;
        int totalHeight = SetOverlayConfig.verticalLayout ? activeSets.size() * spacing : scaledSize;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int x = 0;
        int y = 0;
        switch (SetOverlayConfig.position) {
            case TOP_LEFT: {
                x = 5;
                y = 5;
                break;
            }
            case TOP_RIGHT: {
                x = screenWidth - totalWidth - 5;
                y = 5;
                break;
            }
            case BOTTOM_LEFT: {
                x = 5;
                y = screenHeight - totalHeight - 5;
                break;
            }
            case BOTTOM_RIGHT: {
                x = screenWidth - totalWidth - 5;
                y = screenHeight - totalHeight - 5;
                break;
            }
            case CENTER_LEFT: {
                x = 5;
                y = screenHeight / 2 - totalHeight / 2;
                break;
            }
            case CENTER_RIGHT: {
                x = screenWidth - totalWidth - 5;
                y = screenHeight / 2 - totalHeight / 2;
                break;
            }
            case TOP_CENTER: {
                x = screenWidth / 2 - (SetOverlayConfig.verticalLayout ? scaledSize : totalWidth) / 2;
                y = 5;
                break;
            }
            case BOTTOM_CENTER: {
                x = screenWidth / 2 - (SetOverlayConfig.verticalLayout ? scaledSize : totalWidth) / 2;
                y = screenHeight - totalHeight - 5;
            }
        }
        for (Map.Entry<String, Integer> entry : activeSets.entrySet()) {
            String setId = entry.getKey();
            int count = entry.getValue();
            ResourceLocation icon = new ResourceLocation("rpgseteffects", "textures/gui/sets/" + setId + ".png");
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
            RenderSystem.enableBlend();
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            gui.m_280168_().m_85841_(scale, scale, 1.0f);
            gui.m_280163_(icon, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            gui.m_280168_().m_85849_();
            RenderSystem.disableBlend();
            String text = String.valueOf(count);
            float fontScale = Math.max(0.75f, scale * 0.85f);
            int textWidth = mc.f_91062_.m_92895_(text);
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_((float)(x + scaledSize - 1), (float)(y + scaledSize - 1), 0.0f);
            gui.m_280168_().m_85841_(fontScale, fontScale, 1.0f);
            gui.m_280056_(mc.f_91062_, text, -textWidth, -8, 0xFFFFFF, true);
            gui.m_280168_().m_85849_();
            if (SetOverlayConfig.verticalLayout) {
                y += spacing;
                continue;
            }
            x += spacing;
        }
    }
}

