/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.events;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.HealthClampUtils;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;

@Mod.EventBusSubscriber(modid="rpgseteffects")
public class CuriosEventHandler {
    private static Map<Item, UUID> healthModifiers;
    private static final Map<UUID, UUID> PENDING_HEALTH_FIX;

    private static Map<Item, UUID> getHealthModifiers() {
        if (healthModifiers == null) {
            healthModifiers = new HashMap<Item, UUID>();
            healthModifiers.put((Item)ModItems.BLOOD_FURY_EMBLEM.get(), SetUUIDs.BLOOD_FURY_HEALTH_1);
            healthModifiers.put((Item)ModItems.BLOOD_FURY_AURA.get(), SetUUIDs.BLOOD_FURY_HEALTH_1);
            healthModifiers.put((Item)ModItems.BLOOD_FURY_BARRIER.get(), SetUUIDs.BLOOD_FURY_HEALTH_2);
            healthModifiers.put((Item)ModItems.BLOOD_FURY_ALLY.get(), SetUUIDs.BLOOD_FURY_HEALTH_2);
            healthModifiers.put((Item)ModItems.HELLBRAND_EMBLEM.get(), SetUUIDs.HELLBRAND_HEALTH);
            healthModifiers.put((Item)ModItems.HELLBRAND_AURA.get(), SetUUIDs.HELLBRAND_HEALTH);
            healthModifiers.put((Item)ModItems.HELLBRAND_BARRIER.get(), SetUUIDs.HELLBRAND_HEALTH);
            healthModifiers.put((Item)ModItems.HELLBRAND_ALLY.get(), SetUUIDs.HELLBRAND_HEALTH);
        }
        return healthModifiers;
    }

    @SubscribeEvent
    public static void onCurioUnequip(CurioUnequipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        UUID modId = CuriosEventHandler.getHealthModifiers().get(event.getStack().m_41720_());
        if (modId != null) {
            PENDING_HEALTH_FIX.put(player.m_20148_(), modId);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player.m_9236_() instanceof ServerLevel)) {
            return;
        }
        UUID modId = PENDING_HEALTH_FIX.remove(player.m_20148_());
        if (modId != null) {
            HealthClampUtils.adjustHealthIfModifierRemoved(player, modId);
        }
    }

    static {
        PENDING_HEALTH_FIX = new HashMap<UUID, UUID>();
    }
}

