/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.EffectCooldownManager;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class AltharionSet {
    private static final Set<RegistryObject<Item>> PIECES = Set.of(ModItems.ALTHARION_EMBLEM, ModItems.ALTHARION_AURA, ModItems.ALTHARION_BARRIER, ModItems.ALTHARION_ALLY);
    private static final int ABSORPTION_AMPLIFIER = 1;
    private static final double BASE_DAMAGE = 2.0;
    private static final double EXTRA_DAMAGE = 3.0;
    private static final double SPEED_MULTIPLIER = 0.15;

    public static void apply(ServerPlayer player) {
        int count = AltharionSet.getEquippedCount((Player)player);
        if (count == 0) {
            AltharionSet.removeAll((Player)player);
            return;
        }
        AltharionSet.removeModifiers((Player)player);
        if (count >= 1) {
            AltharionSet.applyAbsorption((Player)player, 1);
        }
        if (count >= 2) {
            AltharionSet.applyAttackDamage((Player)player, 2.0, SetUUIDs.ALTHARION_DAMAGE_BASE, "altharion_damage_base");
        }
        if (count >= 3) {
            AltharionSet.applyMovementSpeed((Player)player, 0.15);
        }
        if (count == 4) {
            AltharionSet.applyAttackDamage((Player)player, 3.0, SetUUIDs.ALTHARION_DAMAGE_EXTRA, "altharion_damage_extra");
        }
    }

    public static Function<ItemStack, List<Component>> getTooltipLines() {
        return stack -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            int count = player != null ? AltharionSet.getEquippedCount((Player)player) : 0;
            return SetTooltipBuilder.build("set.altharion", count, null, AltharionSet.format(2.0), AltharionSet.formatPercent(0.15), AltharionSet.format(3.0));
        };
    }

    private static String format(double value) {
        return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.format("%.1f", value);
    }

    private static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void applyAbsorption(Player player, int amplifier) {
        if (EffectCooldownManager.shouldApply(player, "altharion_absorption", 600)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 600, amplifier, true, false));
        }
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.ALTHARION_SPEED, "altharion_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount, UUID uuid, String name) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22279_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.ALTHARION_SPEED));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> {
            attr.m_22120_(SetUUIDs.ALTHARION_DAMAGE_BASE);
            attr.m_22120_(SetUUIDs.ALTHARION_DAMAGE_EXTRA);
        });
    }

    private static void removeAll(Player player) {
        AltharionSet.removeModifiers(player);
        if (player.m_21023_(MobEffects.f_19617_) && EffectCooldownManager.wasApplied(player, "altharion_absorption")) {
            player.m_21195_(MobEffects.f_19617_);
        }
    }
}

