/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class SanctumSet {
    private static final Set<RegistryObject<Item>> PIECES = Set.of(ModItems.SANCTUM_EMBLEM, ModItems.SANCTUM_AURA, ModItems.SANCTUM_BARRIER, ModItems.SANCTUM_ALLY);
    private static final int RESISTANCE_AMPLIFIER = 1;
    private static final double ARMOR_BONUS = 6.0;
    private static final double KNOCKBACK_RESISTANCE = 0.25;
    private static final double DAMAGE_BONUS = 6.0;

    public static void apply(ServerPlayer player) {
        int count = SanctumSet.getEquippedCount((Player)player);
        if (count == 0) {
            return;
        }
        SanctumSet.removeModifiers((Player)player);
        if (count >= 1) {
            SanctumSet.applyResistance((Player)player, 1);
        }
        if (count >= 2) {
            SanctumSet.applyArmor((Player)player, 6.0);
        }
        if (count >= 3) {
            SanctumSet.applyKnockbackResistance((Player)player, 0.25);
        }
        if (count == 4) {
            SanctumSet.applyAttackDamage((Player)player, 6.0);
        }
    }

    public static Function<ItemStack, List<Component>> getTooltipLines() {
        return stack -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            int count = player != null ? SanctumSet.getEquippedCount((Player)player) : 0;
            return SetTooltipBuilder.build("set.sanctum", count, null, SanctumSet.format(6.0), SanctumSet.formatPercent(0.25), SanctumSet.format(6.0));
        };
    }

    private static String format(double value) {
        return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.format("%.1f", value);
    }

    private static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void applyResistance(Player player, int amplifier) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, amplifier, true, false));
    }

    private static void applyArmor(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22284_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_ARMOR, "sanctum_armor", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyKnockbackResistance(Player player, double value) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22278_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_KNOCKBACK, "sanctum_knockback", value, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_DAMAGE, "sanctum_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22284_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_ARMOR));
        Optional.ofNullable(player.m_21051_(Attributes.f_22278_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_KNOCKBACK));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_DAMAGE));
    }
}

