/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.AttributeUtils;
import com.everydayxp.rpgseteffects.util.SetTooltipHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class HellbrandSet {
    private static final Set<Item> PIECES = Set.of((Item)ModItems.HELLBRAND_EMBLEM.get(), (Item)ModItems.HELLBRAND_AURA.get(), (Item)ModItems.HELLBRAND_BARRIER.get(), (Item)ModItems.HELLBRAND_ALLY.get());

    public static void apply(ServerPlayer player) {
        int count = HellbrandSet.getEquippedCount((Player)player);
        if (count == 0) {
            HellbrandSet.removeModifiers((Player)player);
            return;
        }
        HellbrandSet.removeModifiers((Player)player);
        if (count >= 1) {
            HellbrandSet.applyMovementSpeed((Player)player, 0.1);
        }
        if (count >= 2) {
            HellbrandSet.applyAttackSpeed((Player)player, 0.1);
        }
        if (count >= 3) {
            AttributeUtils.applyMaxHealth(player, 5.0, SetUUIDs.HELLBRAND_HEALTH, "hellbrand_max_health");
        }
        if (count == 4) {
            HellbrandSet.applyAttackDamage((Player)player, 6.0);
        }
    }

    public static List<Component> getTooltipLines() {
        Player player = SetTooltipHelper.getClientPlayer();
        int count = player != null ? HellbrandSet.getEquippedCount(player) : 0;
        List<SetTooltipHelper.BonusLine> bonuses = List.of(new SetTooltipHelper.BonusLine(1, "set.hellbrand.bonus.1"), new SetTooltipHelper.BonusLine(2, "set.hellbrand.bonus.2"), new SetTooltipHelper.BonusLine(3, "set.hellbrand.bonus.3"), new SetTooltipHelper.BonusLine(4, "set.hellbrand.bonus.4"));
        return SetTooltipHelper.generate("set.hellbrand.name", count, bonuses);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.contains(stack.m_41720_()))).map(List::size).orElse(0);
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_SPEED, "hellbrand_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_ATTACK_SPEED, "hellbrand_attack_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.HELLBRAND_DAMAGE, "hellbrand_attack_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        AttributeUtils.removeModifier(player, Attributes.f_22279_, SetUUIDs.HELLBRAND_SPEED);
        AttributeUtils.removeModifier(player, Attributes.f_22283_, SetUUIDs.HELLBRAND_ATTACK_SPEED);
        AttributeUtils.removeModifier(player, Attributes.f_22276_, SetUUIDs.HELLBRAND_HEALTH);
        AttributeUtils.removeModifier(player, Attributes.f_22281_, SetUUIDs.HELLBRAND_DAMAGE);
    }
}

