/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class SanctumSet {
    private static final Set<Item> PIECES = Set.of((Item)ModItems.SANCTUM_EMBLEM.get(), (Item)ModItems.SANCTUM_AURA.get(), (Item)ModItems.SANCTUM_BARRIER.get(), (Item)ModItems.SANCTUM_ALLY.get());

    public static void apply(ServerPlayer player) {
        int count = SanctumSet.getEquippedCount((Player)player);
        if (count == 0) {
            return;
        }
        SanctumSet.removeModifiers((Player)player);
        if (count >= 1) {
            SanctumSet.applyResistance((Player)player, 1);
        }
        if (count >= 2) {
            SanctumSet.applyArmor((Player)player, 6.0);
        }
        if (count >= 3) {
            SanctumSet.applyKnockbackResistance((Player)player, 0.25);
        }
        if (count == 4) {
            SanctumSet.applyAttackDamage((Player)player, 5.0);
        }
    }

    public static List<Component> getTooltipLines() {
        Player player = SetTooltipHelper.getClientPlayer();
        int count = player != null ? SanctumSet.getEquippedCount(player) : 0;
        List<SetTooltipHelper.BonusLine> bonuses = List.of(new SetTooltipHelper.BonusLine(1, "set.sanctum.bonus.1"), new SetTooltipHelper.BonusLine(2, "set.sanctum.bonus.2"), new SetTooltipHelper.BonusLine(3, "set.sanctum.bonus.3"), new SetTooltipHelper.BonusLine(4, "set.sanctum.bonus.4"));
        return SetTooltipHelper.generate("set.sanctum.name", count, bonuses);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.contains(stack.m_41720_()))).map(List::size).orElse(0);
    }

    private static void applyResistance(Player player, int amplifier) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, amplifier, true, false));
    }

    private static void applyArmor(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22284_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_ARMOR, "sanctum_armor", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyKnockbackResistance(Player player, double value) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22278_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_KNOCKBACK, "sanctum_knockback", value, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SANCTUM_DAMAGE, "sanctum_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22284_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_ARMOR));
        Optional.ofNullable(player.m_21051_(Attributes.f_22278_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_KNOCKBACK));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SANCTUM_DAMAGE));
    }
}

