/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.system.SetUUIDs;
import com.everydayxp.rpgseteffects.util.SetTooltipHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import top.theillusivec4.curios.api.CuriosApi;

public class ShadowHunterSet {
    private static final Set<Item> PIECES = Set.of((Item)ModItems.SHADOW_HUNTER_EMBLEM.get(), (Item)ModItems.SHADOW_HUNTER_AURA.get(), (Item)ModItems.SHADOW_HUNTER_BARRIER.get(), (Item)ModItems.SHADOW_HUNTER_ALLY.get());

    public static void apply(ServerPlayer player) {
        int count = ShadowHunterSet.getEquippedCount((Player)player);
        if (count == 0) {
            return;
        }
        ShadowHunterSet.removeModifiers((Player)player);
        if (count >= 1) {
            ShadowHunterSet.applyAttackSpeed((Player)player, 0.1, SetUUIDs.SHADOW_ATTACK_SPEED_1, "shadow_hunter_attack_speed_1");
        }
        if (count >= 2) {
            ShadowHunterSet.applyMovementSpeed((Player)player, 0.2);
        }
        if (count >= 3) {
            ShadowHunterSet.applyAttackDamage((Player)player, 4.0);
        }
        if (count == 4) {
            ShadowHunterSet.applyAttackSpeed((Player)player, 0.1, SetUUIDs.SHADOW_ATTACK_SPEED_2, "shadow_hunter_attack_speed_2");
        }
    }

    public static List<Component> getTooltipLines() {
        Player player = SetTooltipHelper.getClientPlayer();
        int count = player != null ? ShadowHunterSet.getEquippedCount(player) : 0;
        List<SetTooltipHelper.BonusLine> bonuses = List.of(new SetTooltipHelper.BonusLine(1, "set.shadow_hunter.bonus.1"), new SetTooltipHelper.BonusLine(2, "set.shadow_hunter.bonus.2"), new SetTooltipHelper.BonusLine(3, "set.shadow_hunter.bonus.3"), new SetTooltipHelper.BonusLine(4, "set.shadow_hunter.bonus.4"));
        return SetTooltipHelper.generate("set.shadow_hunter.name", count, bonuses);
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.contains(stack.m_41720_()))).map(List::size).orElse(0);
    }

    private static void applyAttackSpeed(Player player, double multiplier, UUID uuid, String name) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22283_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(uuid, name, multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyMovementSpeed(Player player, double multiplier) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SHADOW_MOVE_SPEED, "shadow_hunter_move_speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void applyAttackDamage(Player player, double amount) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22281_);
        if (attr != null) {
            attr.m_22118_(new AttributeModifier(SetUUIDs.SHADOW_DAMAGE, "shadow_hunter_damage", amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private static void removeModifiers(Player player) {
        Optional.ofNullable(player.m_21051_(Attributes.f_22283_)).ifPresent(attr -> {
            attr.m_22120_(SetUUIDs.SHADOW_ATTACK_SPEED_1);
            attr.m_22120_(SetUUIDs.SHADOW_ATTACK_SPEED_2);
        });
        Optional.ofNullable(player.m_21051_(Attributes.f_22279_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SHADOW_MOVE_SPEED));
        Optional.ofNullable(player.m_21051_(Attributes.f_22281_)).ifPresent(attr -> attr.m_22120_(SetUUIDs.SHADOW_DAMAGE));
    }
}

