/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.events;

import com.everydayxp.rpgseteffects.sets.FireAuraSet;
import com.everydayxp.rpgseteffects.sets.HellbrandSet;
import com.everydayxp.rpgseteffects.sets.IceAuraSet;
import com.everydayxp.rpgseteffects.sets.MoonpiercerSet;
import com.everydayxp.rpgseteffects.sets.PoisonAuraSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CombatEffectHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Arrow arrow;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)entity;
        LivingEntity target = event.getEntity();
        Entity entity2 = event.getSource().m_7640_();
        if (entity2 instanceof Arrow && (arrow = (Arrow)entity2).m_19880_().contains("moonpiercer_rain")) {
            return;
        }
        float baseDamage = event.getAmount();
        float comboDamage = HellbrandSet.getBonusDamage(attacker, target, baseDamage);
        event.setAmount(comboDamage);
        HellbrandSet.applySetEffectOnHit(target, attacker);
        if (target.m_21224_()) {
            HellbrandSet.resetHits(attacker, target);
        }
        PoisonAuraSet.onHit(attacker, target);
        FireAuraSet.onHit(attacker, target);
        IceAuraSet.onHit(attacker, target);
        MoonpiercerSet.tryRainOfArrows(attacker, target);
    }
}

