/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class BloodFurySet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.BLOOD_FURY_AMULET, ModItems.BLOOD_FURY_BELT, ModItems.BLOOD_FURY_BODY, ModItems.BLOOD_FURY_BOOTS, ModItems.BLOOD_FURY_HELM, ModItems.BLOOD_FURY_RELIC));
    private static final double ATTACK_SPEED_AMOUNT = 0.25;
    private static final double CRIT_CHANCE_AMOUNT = 0.5;
    private static final double MAX_HP_DAMAGE_AMOUNT = 0.1;
    private static final UUID BLOOD_FURY_ATTACK_SPEED_UUID = UUID.fromString("5dde2c2d-b57b-44ee-8164-1eac4fa29264");
    private static final UUID BLOOD_FURY_CRIT_CHANCE_UUID = UUID.fromString("c704f5e6-c98c-4975-9d23-424fea7b2e13");
    private static final UUID BLOOD_FURY_MAX_HP_DAMAGE_UUID = UUID.fromString("e7bbca7e-36b2-4aaa-9710-3a5a8ab5e555");

    public static void apply(ServerPlayer player) {
        Attribute maxHpDamage;
        Attribute critChance;
        Attribute attackSpeed;
        int count = BloodFurySet.getEquippedCount((Player)player);
        BloodFurySet.removeModifiers(player);
        if (count >= 2 && (attackSpeed = Attributes.f_22283_) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, attackSpeed, BLOOD_FURY_ATTACK_SPEED_UUID, 0.25, "blood_fury_attack_speed", AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (count >= 4 && (critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, critChance, BLOOD_FURY_CRIT_CHANCE_UUID, 0.5, "blood_fury_crit_chance", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 6 && (maxHpDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:max_hp_damage"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, maxHpDamage, BLOOD_FURY_MAX_HP_DAMAGE_UUID, 0.1, "blood_fury_max_hp_damage", AttributeModifier.Operation.ADDITION);
        }
    }

    private static void removeModifiers(ServerPlayer player) {
        Attribute attackSpeed = Attributes.f_22283_;
        Attribute critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"));
        Attribute maxHpDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:max_hp_damage"));
        if (attackSpeed != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, attackSpeed, BLOOD_FURY_ATTACK_SPEED_UUID);
        }
        if (critChance != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, critChance, BLOOD_FURY_CRIT_CHANCE_UUID);
        }
        if (maxHpDamage != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, maxHpDamage, BLOOD_FURY_MAX_HP_DAMAGE_UUID);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        Attribute attackSpeed = Attributes.f_22283_;
        Attribute critChance = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:crit_chance"));
        Attribute maxHpDamage = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore:max_hp_damage"));
        List<Object> bonuses = Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(attackSpeed, 0.25, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(critChance, 0.5, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(maxHpDamage, 0.1, true)));
        return (stack, count) -> SetTooltipBuilder.build("set.blood_fury", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }
}

