/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets;

import com.everydayxp.rpgseteffects.registry.ModItems;
import com.everydayxp.rpgseteffects.util.RPGAttributeHelper;
import com.everydayxp.rpgseteffects.util.SetTooltipBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class SanctumSet {
    private static final Set<RegistryObject<Item>> PIECES = new LinkedHashSet<RegistryObject<Item>>(List.of(ModItems.SANCTUM_AMULET, ModItems.SANCTUM_BELT, ModItems.SANCTUM_BODY, ModItems.SANCTUM_BOOTS, ModItems.SANCTUM_HELM, ModItems.SANCTUM_RELIC));
    private static final double ARMOR_BONUS = 8.0;
    private static final double KNOCKBACK_RESISTANCE_AMOUNT = 1.0;
    private static final double AGGRO_RADIUS_AMOUNT = 10.0;
    private static final UUID SANCTUM_ARMOR_UUID = UUID.fromString("b95aab93-ae70-44fa-b17a-809040f6cd88");
    private static final UUID SANCTUM_KNOCKBACK_UUID = UUID.fromString("e70cf856-dcc3-4546-9392-5f8aa2fc577b");
    private static final UUID SANCTUM_AGGRO_RADIUS_UUID = UUID.fromString("54dccd7d-a1d3-4011-9ebd-0dab2eb364d6");

    public static void apply(ServerPlayer player) {
        Attribute aggroRadius;
        int count = SanctumSet.getEquippedCount((Player)player);
        SanctumSet.removeModifiers(player);
        if (count >= 2) {
            RPGAttributeHelper.applyPlayerModifier(player, Attributes.f_22284_, SANCTUM_ARMOR_UUID, 8.0, "sanctum_armor", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 4) {
            RPGAttributeHelper.applyPlayerModifier(player, Attributes.f_22278_, SANCTUM_KNOCKBACK_UUID, 1.0, "sanctum_knockback_resist", AttributeModifier.Operation.ADDITION);
        }
        if (count >= 6 && (aggroRadius = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aggro_radius"))) != null) {
            RPGAttributeHelper.applyPlayerModifier(player, aggroRadius, SANCTUM_AGGRO_RADIUS_UUID, 10.0, "sanctum_aggro_radius", AttributeModifier.Operation.ADDITION);
        }
    }

    public static BiFunction<ItemStack, Integer, List<Component>> getTooltipLines() {
        ArrayList<RegistryObject<Item>> pieceDefs = new ArrayList<RegistryObject<Item>>(PIECES);
        Attribute aggroRadius = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aggro_radius"));
        ArrayList<List> bonuses = new ArrayList<List>(Arrays.asList(null, List.of(new SetTooltipBuilder.AttributeEntry(Attributes.f_22284_, 8.0, false)), null, List.of(new SetTooltipBuilder.AttributeEntry(Attributes.f_22278_, 1.0, true)), null, List.of(new SetTooltipBuilder.AttributeEntry(aggroRadius, 10.0, false))));
        return (stack, count) -> SetTooltipBuilder.build("set.sanctum", count, pieceDefs, stack, bonuses.toArray());
    }

    public static int getEquippedCount(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> PIECES.stream().anyMatch(obj -> obj.isPresent() && obj.get() == stack.m_41720_()))).map(List::size).orElse(0);
    }

    public static Set<RegistryObject<Item>> getPieces() {
        return PIECES;
    }

    private static void removeModifiers(ServerPlayer player) {
        RPGAttributeHelper.removePlayerModifier((Player)player, Attributes.f_22284_, SANCTUM_ARMOR_UUID);
        RPGAttributeHelper.removePlayerModifier((Player)player, Attributes.f_22278_, SANCTUM_KNOCKBACK_UUID);
        Attribute aggroRadius = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributecore", "aggro_radius"));
        if (aggroRadius != null) {
            RPGAttributeHelper.removePlayerModifier((Player)player, aggroRadius, SANCTUM_AGGRO_RADIUS_UUID);
        }
    }
}

