/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.sets.relics;

import com.everydayxp.rpgseteffects.registry.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class BuildersFlight {
    private static final RegistryObject<Item> ITEM = ModItems.BUILDERS_FLIGHT_CHARM;

    public static void apply(ServerPlayer player) {
        if (BuildersFlight.isEquipped((Player)player)) {
            player.m_150110_().f_35936_ = true;
        } else {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
        }
        player.m_6885_();
    }

    public static int getEquippedCount(ServerPlayer player) {
        return BuildersFlight.isEquipped((Player)player) ? 1 : 0;
    }

    public static boolean isEquipped(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> ITEM.isPresent() && stack.m_41720_() == ITEM.get())).map(list -> !list.isEmpty()).orElse(false);
    }

    public static List<Component> getTooltipLines(ItemStack stack) {
        return List.of(Component.m_237115_((String)"item.rpgseteffects.builders_flight_charm.tooltip.0").m_130940_(ChatFormatting.AQUA), Component.m_237115_((String)"item.rpgseteffects.builders_flight_charm.tooltip.1").m_130940_(ChatFormatting.RED), Component.m_237115_((String)"item.rpgseteffects.builders_flight_charm.tooltip.2").m_130940_(ChatFormatting.GRAY));
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (BuildersFlight.isEquipped(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && BuildersFlight.isEquipped(player = (Player)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && BuildersFlight.isEquipped(player = (Player)entity)) {
            event.setCanceled(true);
        }
    }
}

