/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.rpgseteffects.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class SetTooltipBuilder {
    public static List<Component> build(String baseKey, int activeCount, List<RegistryObject<Item>> pieceDefs, ItemStack stack, Object ... values) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)(baseKey + ".title")).m_130940_(ChatFormatting.GREEN));
        for (int i = 0; i < pieceDefs.size(); ++i) {
            RegistryObject<Item> piece = pieceDefs.get(i);
            boolean equipped = SetTooltipBuilder.isPieceEquipped(piece);
            ChatFormatting color = equipped ? ChatFormatting.WHITE : ChatFormatting.DARK_GRAY;
            String itemNameKey = ((Item)piece.get()).m_5524_();
            MutableComponent name = Component.m_237115_((String)itemNameKey).m_130940_(color);
            if (equipped) {
                name = name.m_7220_((Component)Component.m_237113_((String)" *").m_130940_(ChatFormatting.GREEN));
            }
            tooltip.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)name));
        }
        tooltip.add((Component)Component.m_237119_());
        ArrayList<Object> ordered = new ArrayList<Object>(Arrays.asList(values));
        for (int i = 0; i < ordered.size(); ++i) {
            MutableComponent text;
            Object val = ordered.get(i);
            if (val == null) continue;
            boolean active = activeCount >= i + 1;
            ChatFormatting color = active ? ChatFormatting.GREEN : ChatFormatting.DARK_GRAY;
            String prefix = "(" + (i + 1) + ") Piece:";
            MutableComponent line = Component.m_237113_((String)prefix).m_130940_(color);
            tooltip.add((Component)line);
            if (val instanceof List) {
                List list = (List)val;
                for (Object obj : list) {
                    MutableComponent text2;
                    if (obj instanceof AttributeEntry) {
                        AttributeEntry entry = (AttributeEntry)obj;
                        String formattedAmount = entry.isPercent() ? String.format("+%.0f%% ", entry.amount() * 100.0) : (entry.amount() % 1.0 == 0.0 ? String.format("+%.0f ", entry.amount()) : String.format("+%.1f ", entry.amount()));
                        text2 = Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237113_((String)formattedAmount).m_7220_((Component)Component.m_237115_((String)entry.attribute().m_22087_())).m_130940_(color));
                    } else if (obj instanceof Attribute) {
                        Attribute attribute = (Attribute)obj;
                        text2 = Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_()).m_130940_(color));
                    } else {
                        if (obj instanceof EffectEntry) {
                            EffectEntry effectEntry = (EffectEntry)obj;
                            ChatFormatting nameColor = active ? ChatFormatting.GREEN : ChatFormatting.DARK_GRAY;
                            ChatFormatting descColor = active ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_GRAY;
                            int amp = effectEntry.getAmplifier();
                            String roman = amp > 0 ? " " + SetTooltipBuilder.toRoman(amp + 1) : "";
                            MutableComponent effectName = Component.m_237115_((String)effectEntry.getEffect().m_19481_()).m_130946_(roman).m_130940_(nameColor);
                            MutableComponent effectDesc = Component.m_237115_((String)(effectEntry.getEffect().m_19481_() + ".description")).m_130940_(descColor);
                            MutableComponent effectFull = effectName.m_6881_().m_130946_(": ").m_7220_((Component)effectDesc);
                            tooltip.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)effectFull));
                            continue;
                        }
                        if (obj instanceof Component) {
                            Component comp = (Component)obj;
                            text2 = Component.m_237113_((String)"   ").m_7220_((Component)comp.m_6881_().m_130940_(color));
                        } else {
                            text2 = Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237113_((String)obj.toString()).m_130940_(color));
                        }
                    }
                    tooltip.add((Component)text2);
                }
                continue;
            }
            if (val instanceof AttributeEntry) {
                AttributeEntry entry = (AttributeEntry)val;
                String formattedAmount = entry.isPercent() ? String.format("+%.0f%% ", entry.amount() * 100.0) : (entry.amount() % 1.0 == 0.0 ? String.format("+%.0f ", entry.amount()) : String.format("+%.1f ", entry.amount()));
                text = Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)formattedAmount).m_7220_((Component)Component.m_237115_((String)entry.attribute().m_22087_())).m_130940_(color));
            } else if (val instanceof Attribute) {
                Attribute attribute = (Attribute)val;
                text = Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237115_((String)attribute.m_22087_()).m_130940_(color));
            } else {
                if (val instanceof EffectEntry) {
                    EffectEntry effectEntry = (EffectEntry)val;
                    MutableComponent effectName = Component.m_237115_((String)effectEntry.getEffect().m_19481_()).m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD});
                    MutableComponent effectDesc = Component.m_237115_((String)(effectEntry.getEffect().m_19481_() + ".description")).m_130940_(color);
                    tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)effectName));
                    tooltip.add((Component)Component.m_237113_((String)"         ").m_7220_((Component)effectDesc));
                    continue;
                }
                if (val instanceof Component) {
                    Component comp = (Component)val;
                    text = Component.m_237113_((String)"     ").m_7220_((Component)comp.m_6881_().m_130940_(color));
                } else {
                    String key = baseKey + ".bonus." + (i + 1);
                    text = Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237115_((String)key).m_130940_(color));
                }
            }
            tooltip.add((Component)text);
        }
        return tooltip;
    }

    private static String toRoman(int n) {
        return switch (n) {
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            default -> "I";
        };
    }

    private static boolean isPieceEquipped(RegistryObject<Item> piece) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !piece.isPresent()) {
            return false;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inv -> inv.findCurios(stack -> stack.m_41720_() == piece.get())).map(list -> !list.isEmpty()).orElse(false);
    }

    public record AttributeEntry(Attribute attribute, double amount, boolean isPercent) {
    }

    public static class EffectEntry {
        private final MobEffect effect;
        private final int amplifier;

        public EffectEntry(MobEffect effect, int amplifier) {
            this.effect = effect;
            this.amplifier = amplifier;
        }

        public EffectEntry(MobEffect effect) {
            this(effect, 0);
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getAmplifier() {
            return this.amplifier;
        }
    }
}

