/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.client.model;

import codyhuh.ambientadditions.common.entities.util.IFlopper;
import codyhuh.ambientadditions.common.entities.util.ISwimmer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class GenericGeoModel<E extends LivingEntity>
extends GeoModel<E> {
    private final String model;
    private final String texture;
    private final String anim;

    public GenericGeoModel(String name) {
        this(name, name, name);
    }

    public GenericGeoModel(String model, String texture, String anim) {
        this.model = model;
        this.texture = texture;
        this.anim = anim;
    }

    public ResourceLocation getModelResource(E object) {
        return new ResourceLocation("ambientadditions", "geo/entity/" + this.model + ".geo.json");
    }

    public ResourceLocation getTextureResource(E object) {
        return new ResourceLocation("ambientadditions", "textures/entity/" + this.texture + ".png");
    }

    public ResourceLocation getAnimationResource(E object) {
        return new ResourceLocation("ambientadditions", "animations/entity/" + this.anim + ".animation.json");
    }

    public void setCustomAnimations(E entity, long instanceId, AnimationState<E> customPredicate) {
        super.setCustomAnimations(entity, instanceId, customPredicate);
        CoreGeoBone root = this.getAnimationProcessor().getBone("root");
        if (entity instanceof IFlopper) {
            if (!entity.m_20069_()) {
                root.setRotZ(1.5708f);
            } else {
                root.setRotZ(0.0f);
            }
        }
        if (entity instanceof ISwimmer) {
            if (entity.m_20069_()) {
                EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
                root.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
                root.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
            } else {
                root.setRotX(0.0f);
                root.setRotY(0.0f);
            }
        }
    }
}

