/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.client.renderer;

import codyhuh.ambientadditions.common.entities.ChocolateChipStarfish;
import codyhuh.ambientadditions.common.entities.RabbitSnail;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class GenericGeoRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    private float scale = 1.0f;

    public GenericGeoRenderer(EntityRendererProvider.Context renderManager, Supplier<GeoModel<T>> model) {
        super(renderManager, model.get());
        this.f_114477_ = 0.3f;
    }

    public GenericGeoRenderer(EntityRendererProvider.Context renderManager, Supplier<GeoModel<T>> model, float scale) {
        this(renderManager, model.get(), scale);
        this.scale = scale;
    }

    public GenericGeoRenderer(EntityRendererProvider.Context mgr, GeoModel<T> modelProvider) {
        super(mgr, modelProvider);
    }

    public GenericGeoRenderer(EntityRendererProvider.Context mgr, GeoModel<T> modelProvider, float scale) {
        this(mgr, modelProvider);
        this.scale = scale;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        AgeableMob mob;
        if (this.scale != 1.0f) {
            stack.m_85841_(this.scale, this.scale, this.scale);
        }
        if (entity instanceof AgeableMob && (mob = (AgeableMob)entity).m_6162_()) {
            stack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        if (entity instanceof RabbitSnail) {
            stack.m_252880_(0.0f, -0.01f, 0.0f);
        }
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedGeoModel, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (animatable instanceof ChocolateChipStarfish) {
            Optional arm;
            int i;
            ChocolateChipStarfish starfish = (ChocolateChipStarfish)((Object)animatable);
            BakedGeoModel model = RenderUtils.getGeoModelForEntity((Entity)starfish).getBakedModel(new ResourceLocation("ambientadditions", "geo/entity/chocolate_chip_starfish.geo.json"));
            for (i = 1; i <= 5; ++i) {
                arm = model.getBone("Arm" + i);
                arm.ifPresent(geoBone -> geoBone.setHidden(true));
            }
            for (i = 1; i <= (int)starfish.m_21223_(); ++i) {
                arm = model.getBone("Arm" + i);
                arm.ifPresent(geoBone -> geoBone.setHidden(false));
            }
        }
        super.preRender(poseStack, animatable, bakedGeoModel, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }
}

