/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.blocks;

import codyhuh.ambientadditions.common.block_entities.CrateBlockEntity;
import codyhuh.ambientadditions.registry.AABlockEntities;
import codyhuh.ambientadditions.registry.AAItems;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock {
    public static final BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");

    public CrateBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AABlockEntities.CRATE.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)FULL)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)AAItems.CRATE.get());
            if (!player.m_150110_().f_35937_) {
                if (!player.m_150109_().m_36054_(stack)) {
                    player.m_36176_(stack, true);
                } else {
                    player.m_36356_(stack);
                }
            }
            level.m_46796_(2001, pos, CrateBlock.m_49956_((BlockState)level.m_8055_(pos)));
            level.m_7471_(pos, false);
            CrateBlock.releaseEntity(crate, level, pos, Direction.m_235672_((RandomSource)level.m_213780_()));
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    private static InteractionResult releaseEntity(CrateBlockEntity crate, Level level, BlockPos pos, Direction direction) {
        LivingEntity entity;
        EntityType type = EntityType.m_20637_((CompoundTag)crate.getCreatureData()).orElse(null);
        if (level.m_5776_() && type == null || (entity = (LivingEntity)type.m_20615_(level)) == null) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            UUID id = entity.m_20148_();
            entity.deserializeNBT(crate.getCreatureData());
            entity.m_20084_(id);
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)entity);
            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11725_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.getPersistentData().m_128379_("IsSedated", false);
            level.m_46747_(pos);
            crate.m_7651_();
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.m_61104_(new Property[]{FULL});
    }
}

