/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.ai.goal.MoleDiggingGoal;
import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.registry.AAEntities;
import codyhuh.ambientadditions.registry.AAItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mole
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Mole.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private MoleDiggingGoal eatBlockGoal;
    public int eatAnimationTick;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Mole(EntityType<? extends Animal> p_i48568_1_, Level p_i48568_2_) {
        super(p_i48568_1_, p_i48568_2_);
    }

    protected void m_8099_() {
        this.eatBlockGoal = new MoleDiggingGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AAItems.WORM.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.MOLE_SPAWN_EGG.get());
    }

    public static boolean checkMoleSpawnRules(EntityType<? extends Animal> p_223363_0_, LevelAccessor p_223363_1_, MobSpawnType p_223363_2_, BlockPos p_223363_3_, RandomSource p_223363_4_) {
        return p_223363_1_.m_8055_(p_223363_3_.m_7495_()).m_60713_(Blocks.f_50440_) && p_223363_1_.m_8044_() > 12000L && p_223363_1_.m_8044_() < 23999L;
    }

    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 90;
        } else {
            super.m_7822_(id);
        }
    }

    private boolean isDigging() {
        return this.eatAnimationTick > 0;
    }

    public boolean m_6898_(ItemStack p_70877_1_) {
        return p_70877_1_.m_41720_() == AAItems.WORM.get();
    }

    @Nullable
    public Mole getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Mole mole = (Mole)((EntityType)AAEntities.MOLE.get()).m_20615_((Level)p_241840_1_);
        int i = this.f_19796_.m_188503_(3);
        if (this.f_19796_.m_188503_(20) != 0) {
            i = p_241840_2_ instanceof Mole && this.f_19796_.m_188499_() ? ((Mole)p_241840_2_).getVariant() : this.getVariant();
        }
        mole.setVariant(i);
        return mole;
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42446_ && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_12013_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack itemstack1 = new ItemStack((ItemLike)AAItems.MOLE_BUCKET.get());
            this.saveToBucketTag(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_230254_1_, itemstack1);
                itemstack1.m_41784_().m_128405_("Age", this.m_146764_());
            }
            if (itemstack.m_41619_()) {
                p_230254_1_.m_21008_(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.m_150109_().m_36054_(itemstack1)) {
                p_230254_1_.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected void saveToBucketTag(ItemStack p_204211_1_) {
        if (this.m_8077_()) {
            p_204211_1_.m_41714_(this.m_7770_());
        }
        CompoundTag compoundnbt = p_204211_1_.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.225);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (dataTag != null && dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
            this.m_146762_(dataTag.m_128451_("Age"));
        } else {
            this.setVariant(this.f_19796_.m_188503_(3));
        }
        return spawnDataIn;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isDigging()) {
            event.setAnimation(AAAnimations.ACTION);
        } else if (event.isMoving()) {
            event.setAnimation(AAAnimations.WALK);
        } else {
            event.setAnimation(AAAnimations.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

