/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities.item;

import codyhuh.ambientadditions.AmbientAdditions;
import codyhuh.ambientadditions.common.items.DartItem;
import codyhuh.ambientadditions.data.SedationProvider;
import codyhuh.ambientadditions.registry.AAEntities;
import codyhuh.ambientadditions.registry.AAItems;
import codyhuh.ambientadditions.registry.AAParticles;
import codyhuh.ambientadditions.registry.AATags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class DartEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private final DartItem arrow = (DartItem)((Object)AAItems.DART.get());

    public DartEntity(EntityType<? extends AbstractArrow> p_i48546_1_, Level p_i48546_2_) {
        super(p_i48546_1_, p_i48546_2_);
    }

    public DartEntity(Level p_i46758_1_, LivingEntity p_i46758_2_) {
        super((EntityType)AAEntities.DART.get(), p_i46758_2_, p_i46758_1_);
    }

    protected void m_5790_(EntityHitResult result) {
        PathfinderMob mob;
        Entity target = result.m_82443_();
        if (result.m_6662_().equals((Object)HitResult.Type.ENTITY) && target instanceof PathfinderMob && !(mob = (PathfinderMob)target).m_6336_().equals(MobType.f_21641_) && !mob.m_6336_().equals(MobType.f_21643_) && !target.m_6095_().m_204039_(AATags.UNCRATEABLE)) {
            int timer = 600;
            LazyOptional cap = mob.getCapability(SedationProvider.SEDATION_CAP);
            CompoundTag tag = mob.getPersistentData();
            cap.ifPresent(provider -> {
                provider.setLevel(provider.getLevel() + 1);
                if (provider.getLevel() >= AmbientAdditions.sedationLvlRequiredToCapture(mob.m_21233_())) {
                    mob.getPersistentData().m_128379_("IsSedated", true);
                } else {
                    Level patt2448$temp = mob.m_9236_();
                    if (patt2448$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt2448$temp;
                        if (!tag.m_128471_("IsSedated")) {
                            DartEntity.stunParticles((LivingEntity)mob, 3 + provider.getLevel() * 3, serverLevel);
                        }
                    }
                }
                provider.setTimer(timer);
            });
        }
        super.m_5790_(result);
    }

    private static void stunParticles(LivingEntity entity, int amount, ServerLevel level) {
        for (int i = 0; i < amount; ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)AAParticles.STUN.get()), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)AAItems.DART.get());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity shooter = this.m_19749_();
        buffer.writeInt(shooter == null ? 0 : shooter.m_19879_());
        buffer.m_130130_(Item.m_41393_((Item)this.arrow));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

