/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.items;

import codyhuh.ambientadditions.AmbientAdditions;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class AACatchableItem
extends BucketItem {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Item item1;
    private final boolean hasTooltip;

    public AACatchableItem(Supplier<EntityType<?>> entityType, Item item, boolean hasTooltip, Item.Properties properties) {
        this(entityType, Fluids.f_76191_, item, hasTooltip, properties);
    }

    public AACatchableItem(Supplier<EntityType<?>> entityType, Fluid fluid, Item item, boolean hasTooltip, Item.Properties properties) {
        super(fluid, properties);
        this.entityType = entityType;
        this.item1 = item;
        this.hasTooltip = hasTooltip;
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> AmbientAdditions.CALLBACKS.add(() -> ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("ambientadditions", "variant"), (stack, world, player, i) -> stack.m_41782_() ? (float)stack.m_41783_().m_128451_("Variant") : 0.0f)));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (!world.f_46443_) {
            ItemStack itemstack = context.m_43722_();
            BlockPos blockpos = context.m_8083_();
            Direction direction = context.m_43719_();
            BlockState blockstate = world.m_8055_(blockpos);
            BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
            Supplier<EntityType<?>> type = this.entityType;
            Entity entityType = type.get().m_20592_((ServerLevel)world, itemstack, player, blockpos1, MobSpawnType.BUCKET, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
            if (entityType != null) {
                if (player != null && !player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    if (context.m_43722_().m_41619_()) {
                        player.m_21008_(context.m_43724_(), new ItemStack((ItemLike)this.item1));
                    } else {
                        player.m_36356_(new ItemStack((ItemLike)this.item1));
                    }
                }
                this.m_7718_(player, (LevelAccessor)world, blockpos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (this.hasTooltip && stack.m_41782_()) {
            MutableComponent variant = Component.m_237115_((String)(this.getEntityType().m_20675_() + "." + stack.m_41783_().m_128451_("Variant"))).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)variant);
        }
    }

    protected EntityType<?> getEntityType() {
        return this.entityType.get();
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor worldIn, BlockPos pos) {
        if (this.getFluid().m_205067_(FluidTags.f_13131_)) {
            worldIn.m_5594_(player, pos, SoundEvents.f_144075_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else {
            worldIn.m_5594_(player, pos, SoundEvents.f_12016_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }
}

