/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.fusion_patcher.mixin;

import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.packet.PacketToggleConnecting;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainerScreen;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.PreviewModeButtonWidget;
import dev.hail.fusion_patcher.rechiseled.ScrollButtonWidget;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BaseChiselingContainerScreen.class})
public abstract class BaseChiselingContainerScreenMixin<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    @Shadow(remap=false)
    public static int previewMode = 0;
    @Shadow(remap=false)
    private ChiselAllWidget chiselAllWidget;
    @Unique
    private static int fusionPatcher$entryScroll = 0;

    @Shadow(remap=false)
    private ChiselingEntry getEntry(int index) {
        ChiselingRecipe recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        if (recipe == null) {
            return null;
        }
        return index >= 0 && index < recipe.getEntries().size() ? (ChiselingEntry)recipe.getEntries().get(index) : null;
    }

    @Shadow(remap=false)
    private void selectEntry(int index) {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketSelectEntry(index));
    }

    @Shadow(remap=false)
    private void toggleConnecting() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketToggleConnecting());
    }

    @Shadow(remap=false)
    private void chiselAll() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketChiselAll());
    }

    public BaseChiselingContainerScreenMixin(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    protected void addWidgets() {
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 5; ++column) {
                int index = row * 5 + column;
                int x = 9 + 20 * column;
                int y = 17 + 22 * row;
                this.addWidget((Widget)new EntryButtonWidget(x, y, 20, 22, () -> this.getEntry(index + fusionPatcher$entryScroll * 5), () -> ((BaseChiselingContainer)this.container).currentEntry, () -> this.selectEntry(index + fusionPatcher$entryScroll * 5), () -> ((BaseChiselingContainer)this.container).connecting));
            }
        }
        this.addWidget((Widget)new EntryPreviewWidget(117, 17, 68, 69, () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return null;
            }
            return ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return false;
            }
            Item currentItem = ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            return currentItem instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 18, 19, 21, 2, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 2;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 41, 19, 21, 1, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 1;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 64, 19, 21, 0, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 0;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(193, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).connecting, () -> ((BaseChiselingContainer)this.container).currentEntry, this::toggleConnecting));
        this.addWidget((Widget)new ScrollButtonWidget(110, 100, 14, 10, true, () -> this.fusionPatcher$scroll(true)));
        this.addWidget((Widget)new ScrollButtonWidget(110, 110, 14, 10, false, () -> this.fusionPatcher$scroll(false)));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(127, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).currentEntry, this::chiselAll));
    }

    @Inject(method={"getEntry"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void injectedScrollReset(int index, CallbackInfoReturnable<T> ci, ChiselingRecipe recipe) {
        if (recipe == null) {
            fusionPatcher$entryScroll = 0;
        } else if (recipe.getEntries().size() < fusionPatcher$entryScroll * 5 + 20) {
            fusionPatcher$entryScroll = 0;
        }
    }

    @Unique
    private void fusionPatcher$scroll(boolean up) {
        ChiselingRecipe recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        if (recipe != null) {
            if (up) {
                fusionPatcher$entryScroll = fusionPatcher$entryScroll > 0 ? --fusionPatcher$entryScroll : 0;
            } else if (recipe.getEntries().size() > fusionPatcher$entryScroll * 5 + 25) {
                ++fusionPatcher$entryScroll;
            }
        }
    }
}

