/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear.database;

import ecp.npuclear.database.StoredEnderChest;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnderChestStorageDownload {
    private final File file;
    private FileConfiguration config;

    public EnderChestStorageDownload(String filePath) {
        this.file = new File(filePath);
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveEnderChest(UUID playerUUID, List<ItemStack> items, long timestamp) {
        String path = "enderchests." + playerUUID.toString();
        ArrayList<Map> serializedItems = new ArrayList<Map>();
        for (ItemStack item : items) {
            if (item == null) continue;
            serializedItems.add(item.serialize());
        }
        List chestList = Optional.ofNullable(this.config.getList(path)).orElse(new ArrayList());
        HashMap<String, Serializable> chestData = new HashMap<String, Serializable>();
        chestData.put("items", serializedItems);
        chestData.put("timestamp", Long.valueOf(timestamp));
        chestList.add(chestData);
        this.config.set(path, (Object)chestList);
        this.save();
    }

    public List<StoredEnderChest> getEnderChests(UUID playerUUID) {
        String path = "enderchests." + playerUUID.toString();
        List chestList = Optional.ofNullable(this.config.getList(path)).orElse(new ArrayList());
        ArrayList<StoredEnderChest> enderChests = new ArrayList<StoredEnderChest>();
        for (Map chestData : chestList) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            Object rawItems = chestData.get("items");
            if (rawItems instanceof List) {
                for (Object itemData : (List)rawItems) {
                    if (!(itemData instanceof Map)) continue;
                    try {
                        items.add(ItemStack.deserialize((Map)((Map)itemData)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            long timestamp = chestData.getOrDefault("timestamp", System.currentTimeMillis());
            enderChests.add(new StoredEnderChest(items, timestamp));
        }
        return enderChests;
    }

    public List<ItemStack> loadEnderChest(Player player) {
        UUID playerUUID = player.getUniqueId();
        List<StoredEnderChest> storedChests = this.getEnderChests(playerUUID);
        if (!storedChests.isEmpty()) {
            return storedChests.get(storedChests.size() - 1).getItems();
        }
        return new ArrayList<ItemStack>();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

