/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear;

import ecp.npuclear.commands.EnderChestCommand;
import ecp.npuclear.commands.MainCommand;
import ecp.npuclear.dataload.EnderChestStorage;
import ecp.npuclear.listeners.EnderChestListener;
import ecp.npuclear.managers.DatabaseManager;
import ecp.npuclear.managers.EnderChestManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EnderChestPlus
extends JavaPlugin {
    private EnderChestManager enderChestManager;
    private DatabaseManager databaseManager;
    private EnderChestStorage enderChestStorage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.databaseManager = new DatabaseManager(this);
        this.enderChestStorage = new EnderChestStorage(this.databaseManager);
        this.enderChestManager = new EnderChestManager(this, this.enderChestStorage);
        if (!this.databaseManager.connect()) {
            this.getLogger().severe("ERROR CONNECTING DATABASE DISABLING PLUGIN");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.enderChestManager = new EnderChestManager(this, this.getStorage());
        this.getServer().getPluginManager().registerEvents((Listener)new EnderChestListener(this.enderChestManager), (Plugin)this);
        if (this.getCommand("ecp") != null) {
            this.getCommand("ecp").setExecutor((CommandExecutor)new MainCommand(this, this.enderChestManager.getStorage()));
        }
        if (this.getCommand("ec") != null) {
            this.getCommand("ec").setExecutor((CommandExecutor)new EnderChestCommand(this));
        }
        this.getLogger().info("EnderChestPlus has been successfully enabled!");
    }

    public void onDisable() {
        if (this.databaseManager != null && !this.databaseManager.disconnect()) {
            this.getLogger().severe("Failed to properly disconnect from the database.");
        }
        this.getLogger().info("EnderChestPlus has been disabled.");
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EnderChestStorage getStorage() {
        return this.enderChestStorage;
    }
}

