/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear.commands;

import ecp.npuclear.EnderChestPlus;
import ecp.npuclear.database.EnderChestStorageDownload;
import ecp.npuclear.dataload.EnderChestStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MainCommand
implements CommandExecutor,
TabCompleter,
Listener {
    private EnderChestPlus plugin;
    private final Map<UUID, String> searchingPlayers = new HashMap<UUID, String>();

    public MainCommand(EnderChestPlus plugin, EnderChestStorageDownload storage, EnderChestStorageDownload storage1) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public MainCommand(EnderChestPlus plugin, EnderChestStorage storage) {
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &cOnly players can execute this command."));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &dYou are running &5EnderChestPlus &din version &cv&e1.1"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "view": {
                if (args.length == 1) {
                    player.openInventory(player.getEnderChest());
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"[&5&lENDERCHEST&d&l+&7] &dOpening your &5EnderChest"));
                    break;
                }
                if (args.length != 2) break;
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null || !target.isOnline()) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"[&5&lENDERCHEST&d&l+&7] &dThat player is not connected."));
                    break;
                }
                player.openInventory(target.getEnderChest());
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[&5&lENDERCHEST&d&l+&7] &dOpening &5" + target.getName() + "&5's &dEnderChest")));
                break;
            }
            case "menu": {
                this.openMainMenu(player, 1);
                break;
            }
            case "deletechest": {
                if (args.length < 2) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &5Usage &d/ecp &fdeletechest &7<player>"));
                    return true;
                }
                Player targetDelete = Bukkit.getPlayer((String)args[1]);
                if (targetDelete == null || !targetDelete.isOnline()) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &cThat player is not online."));
                    return true;
                }
                targetDelete.getEnderChest().clear();
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&5&lENDERCHEST&d&l+&7] &dDeleted &5" + targetDelete.getName() + "'s &dEnder Chest.")));
                break;
            }
            case "help": {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7----------&5&lENDERCHEST&d&LPLUS &5&lCOMMANDS&7----------"));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e"));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &fview &7<Player> &8View your or other player's enderchest."));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &fadditem &7<material> <player> &8Adds an item to an enderchest of a player."));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &fhelp &8Shows the help message of the plugin"));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &fdeletechest &7<player> &8deletes the enderchest of a player"));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &freload &8Reloads the plugin configuration."));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&d/ecp &fmenu &8Opens the all conected enderchests menu."));
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7--------------------"));
                break;
            }
            case "additem": {
                if (args.length < 3) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &5Usage &d/ecp &fadditem &7<material> <player>"));
                    return true;
                }
                Material material = Material.getMaterial((String)args[1].toUpperCase());
                if (material == null) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &5Usage &d/ecp &fadditem &c<material> &7<player>"));
                    return true;
                }
                Player targetAdd = Bukkit.getPlayer((String)args[2]);
                if (targetAdd == null || !targetAdd.isOnline()) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &5That player is not online."));
                    return true;
                }
                Inventory enderChest = targetAdd.getEnderChest();
                ItemStack item = new ItemStack(material, 1);
                enderChest.addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&5&lENDERCHEST&d&l+&7] &dAdded &e&l" + material.name() + " &dto &e" + targetAdd.getName() + " &5EnderChest&d.")));
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &aConfig successfully reloaded"));
                break;
            }
            default: {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&5&lENDERCHEST&d&l+&7] &dUnknown Subcommand please use &5/ecp help &dto see all the commands."));
            }
        }
        return true;
    }

    private void openMainMenu(Player player, int page) {
        Inventory menu = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&lENDERCHESTS"));
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        int maxPerPage = 45;
        int startIndex = (page - 1) * maxPerPage;
        for (int i = 0; i < maxPerPage && startIndex + i < players.size(); ++i) {
            Player target = (Player)players.get(startIndex + i);
            ItemStack enderChest = new ItemStack(Material.ENDER_CHEST);
            ItemMeta meta = enderChest.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + target.getName());
            enderChest.setItemMeta(meta);
            menu.setItem(i, enderChest);
        }
        ItemStack searchItem = new ItemStack(Material.OAK_SIGN);
        ItemMeta searchMeta = searchItem.getItemMeta();
        searchMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Search");
        searchItem.setItemMeta(searchMeta);
        menu.setItem(45, searchItem);
        player.openInventory(menu);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        if (event.getView().getTitle().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&lENDERCHESTS"))) {
            event.setCancelled(true);
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            if (clickedItem.getType() == Material.OAK_SIGN) {
                player.closeInventory();
                this.searchingPlayers.put(player.getUniqueId(), "");
                player.sendTitle(String.valueOf(ChatColor.YELLOW) + "Search", String.valueOf(ChatColor.GRAY) + "an enderchest", 10, 60, 10);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = List.of("view", "help", "reload", "additem", "deletechest", "menu");
            for (String sub : subcommands) {
                if (!sub.startsWith(args[0].toLowerCase())) continue;
                completions.add(sub);
            }
        }
        return completions;
    }
}

