/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear.dataload;

import ecp.npuclear.managers.DatabaseManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EnderChestLoader {
    private final DatabaseManager db;

    public EnderChestLoader(DatabaseManager db) {
        this.db = db;
    }

    public void loadEnderChest(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.db.plugin, () -> {
            try (Connection conn = this.db.getConnection();){
                String sql = "SELECT slot, item FROM enderchests WHERE uuid = ?;";
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setString(1, player.getUniqueId().toString());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    int slot = rs.getInt("slot");
                    ItemStack item = this.deserializeItem(rs.getBytes("item"));
                    if (item == null) continue;
                    Bukkit.getScheduler().runTask((Plugin)this.db.plugin, () -> player.getEnderChest().setItem(slot, item));
                }
            }
            catch (IOException | ClassNotFoundException | SQLException e) {
                e.printStackTrace();
            }
        });
    }

    private ItemStack deserializeItem(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (ItemStack)ois.readObject();
    }
}

