/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear.dataload;

import ecp.npuclear.managers.DatabaseManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnderChestStorage {
    private final DatabaseManager db;

    public EnderChestStorage(DatabaseManager db) {
        this.db = db;
    }

    public void saveEnderChest(Player player) {
        try (Connection conn = this.db.getConnection();){
            String sql = "REPLACE INTO enderchests (uuid, slot, item) VALUES (?, ?, ?);";
            PreparedStatement stmt = conn.prepareStatement(sql);
            for (int i = 0; i < player.getEnderChest().getSize(); ++i) {
                ItemStack item = player.getEnderChest().getItem(i);
                if (item == null || item.getType() == Material.AIR) continue;
                stmt.setString(1, player.getUniqueId().toString());
                stmt.setInt(2, i);
                stmt.setBytes(3, this.serializeItem(item));
                stmt.executeUpdate();
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
    }

    private byte[] serializeItem(ItemStack item) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(item);
        oos.close();
        return baos.toByteArray();
    }

    public List<ItemStack> loadEnderChest(Player player) {
        return null;
    }
}

