/*
 * Decompiled with CFR 0.152.
 */
package ecp.npuclear.managers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private Connection connection;
    public final JavaPlugin plugin;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean connect() {
        String type = this.plugin.getConfig().getString("database.type", "sqlite");
        try {
            if (type.equalsIgnoreCase("mysql")) {
                String host = this.plugin.getConfig().getString("database.mysql.host");
                int port = this.plugin.getConfig().getInt("database.mysql.port");
                String db = this.plugin.getConfig().getString("database.mysql.database");
                String user = this.plugin.getConfig().getString("database.mysql.user");
                String pass = this.plugin.getConfig().getString("database.mysql.password");
                String url = "jdbc:mysql://" + host + ":" + port + "/" + db + "?useSSL=false";
                this.connection = DriverManager.getConnection(url, user, pass);
            } else {
                String url = "jdbc:sqlite:" + String.valueOf(this.plugin.getDataFolder()) + "/data.db";
                this.connection = DriverManager.getConnection(url);
            }
            this.plugin.getLogger().info("Connected to database.");
            this.createTable();
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error trying to connect to database", e);
            return false;
        }
    }

    public boolean disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.plugin.getLogger().info("Disconnected from database.");
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error trying to disconnect from database", e);
                return false;
            }
        }
        return true;
    }

    private void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS enderchests (uuid TEXT, slot INTEGER, item BLOB, PRIMARY KEY(uuid, slot));";
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating table", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

