/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs;

import com.fancyinnovations.config.featureflags.FeatureFlag;
import com.fancyinnovations.config.featureflags.FeatureFlagConfig;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.oliver.fancyanalytics.api.FancyAnalyticsAPI;
import de.oliver.fancyanalytics.api.metrics.MetricSupplier;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancyanalytics.logger.appender.ConsoleAppender;
import de.oliver.fancyanalytics.logger.appender.JsonAppender;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancyanalytics.sdk.events.Event;
import de.oliver.fancylib.FancyLib;
import de.oliver.fancylib.Metrics;
import de.oliver.fancylib.VersionConfig;
import de.oliver.fancylib.logging.PluginMiddleware;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancylib.serverSoftware.schedulers.BukkitScheduler;
import de.oliver.fancylib.serverSoftware.schedulers.FancyScheduler;
import de.oliver.fancylib.serverSoftware.schedulers.FoliaScheduler;
import de.oliver.fancylib.translations.Language;
import de.oliver.fancylib.translations.TextConfig;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.versionFetcher.MasterVersionFetcher;
import de.oliver.fancylib.versionFetcher.VersionFetcher;
import de.oliver.fancynpcs.ActionManagerImpl;
import de.oliver.fancynpcs.AttributeManagerImpl;
import de.oliver.fancynpcs.FancyNpcsConfigImpl;
import de.oliver.fancynpcs.NpcManagerImpl;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.NpcManager;
import de.oliver.fancynpcs.api.actions.types.BlockUntilDoneAction;
import de.oliver.fancynpcs.api.actions.types.ConsoleCommandAction;
import de.oliver.fancynpcs.api.actions.types.ExecuteRandomActionAction;
import de.oliver.fancynpcs.api.actions.types.MessageAction;
import de.oliver.fancynpcs.api.actions.types.NeedPermissionAction;
import de.oliver.fancynpcs.api.actions.types.PlaySoundAction;
import de.oliver.fancynpcs.api.actions.types.PlayerCommandAction;
import de.oliver.fancynpcs.api.actions.types.PlayerCommandAsOpAction;
import de.oliver.fancynpcs.api.actions.types.SendToServerAction;
import de.oliver.fancynpcs.api.actions.types.WaitAction;
import de.oliver.fancynpcs.api.skins.SkinData;
import de.oliver.fancynpcs.api.skins.SkinManager;
import de.oliver.fancynpcs.commands.CloudCommandManager;
import de.oliver.fancynpcs.listeners.PlayerChangedWorldListener;
import de.oliver.fancynpcs.listeners.PlayerJoinListener;
import de.oliver.fancynpcs.listeners.PlayerLoadedListener;
import de.oliver.fancynpcs.listeners.PlayerNpcsListener;
import de.oliver.fancynpcs.listeners.PlayerQuitListener;
import de.oliver.fancynpcs.listeners.PlayerTeleportListener;
import de.oliver.fancynpcs.listeners.PlayerUseUnknownEntityListener;
import de.oliver.fancynpcs.skins.SkinManagerImpl;
import de.oliver.fancynpcs.skins.SkinUtils;
import de.oliver.fancynpcs.skins.cache.SkinCacheFile;
import de.oliver.fancynpcs.skins.cache.SkinCacheMemory;
import de.oliver.fancynpcs.skins.mineskin.MineSkinQueue;
import de.oliver.fancynpcs.skins.mojang.MojangQueue;
import de.oliver.fancynpcs.skins.uuidcache.UUIDFileCache;
import de.oliver.fancynpcs.tests.PlaceholderApiEnv;
import de.oliver.fancynpcs.tracker.TurnToPlayerTracker;
import de.oliver.fancynpcs.tracker.VisibilityTracker;
import de.oliver.fancynpcs.utils.OldSkinCacheMigrator;
import de.oliver.fancynpcs.v1_19_4.Npc_1_19_4;
import de.oliver.fancynpcs.v1_19_4.PacketReader_1_19_4;
import de.oliver.fancynpcs.v1_20.PacketReader_1_20;
import de.oliver.fancynpcs.v1_20_1.Npc_1_20_1;
import de.oliver.fancynpcs.v1_20_2.Npc_1_20_2;
import de.oliver.fancynpcs.v1_20_4.Npc_1_20_4;
import de.oliver.fancynpcs.v1_20_6.Npc_1_20_6;
import de.oliver.fancynpcs.v1_21_1.Npc_1_21_1;
import de.oliver.fancynpcs.v1_21_11.Npc_1_21_11;
import de.oliver.fancynpcs.v1_21_3.Npc_1_21_3;
import de.oliver.fancynpcs.v1_21_4.Npc_1_21_4;
import de.oliver.fancynpcs.v1_21_5.Npc_1_21_5;
import de.oliver.fancynpcs.v1_21_6.Npc_1_21_6;
import de.oliver.fancynpcs.v1_21_9.Npc_1_21_9;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FancyNpcs
extends JavaPlugin
implements FancyNpcsPlugin {
    public static final FeatureFlag PLAYER_NPCS_FEATURE_FLAG = new FeatureFlag("player-npcs", "Every player can only manage the npcs they have created", false);
    public static final FeatureFlag USE_NATIVE_THREADS_FEATURE_FLAG = new FeatureFlag("use-native-threads", "Use native threads instead of virtual threads.", false);
    public static final FeatureFlag ENABLE_DEBUG_MODE_FEATURE_FLAG = new FeatureFlag("enable-debug-mode", "Enable debug mode", false);
    public static final FeatureFlag ENABLE_FOLIA_VISIBILITY_FIX_FEATURE_FLAG = new FeatureFlag("enable-folia-visibility-fix", "When enabled, all npcs will respawn after 100ms when they should spawn", false);
    public static final FeatureFlag USE_MINECRAFT_USERCACHE_FEATURE_FLAG = new FeatureFlag("use-minecraft-usercache", "Include the content of usercache.json to the username->uuid cache", false);
    private static FancyNpcs instance;
    private final ExtendedFancyLogger fancyLogger;
    private final ScheduledExecutorService npcThread;
    private final FancyScheduler scheduler;
    private final FancyNpcsConfigImpl config;
    private final VersionConfig versionConfig;
    private final FeatureFlagConfig featureFlagConfig;
    private final VersionFetcher versionFetcher;
    private final FancyAnalyticsAPI fancyAnalytics;
    private CloudCommandManager commandManager;
    private TextConfig textConfig;
    private Translator translator;
    private Function<NpcData, Npc> npcAdapter;
    private NpcManagerImpl npcManager;
    private AttributeManagerImpl attributeManager;
    private SkinManagerImpl skinManager;
    private ActionManagerImpl actionManager;
    private VisibilityTracker visibilityTracker;
    private boolean usingPlotSquared;

    public FancyNpcs() {
        instance = this;
        ConsoleAppender consoleAppender = new ConsoleAppender("[{loggerName}] ({threadName}) {logLevel}: {message}");
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        File logsFile = new File("plugins/FancyNpcs/logs/FN-logs-" + date + ".txt");
        if (!logsFile.exists()) {
            try {
                logsFile.getParentFile().mkdirs();
                logsFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonAppender jsonAppender = new JsonAppender(false, false, true, logsFile.getPath());
        this.fancyLogger = new ExtendedFancyLogger("FancyNpcs", LogLevel.INFO, List.of(consoleAppender, jsonAppender), List.of(new PluginMiddleware((Plugin)this)));
        this.npcThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FancyNpcs-Npcs").build());
        this.scheduler = ServerSoftware.isFolia() ? new FoliaScheduler(instance) : new BukkitScheduler(instance);
        this.config = new FancyNpcsConfigImpl();
        this.versionFetcher = new MasterVersionFetcher(this.getName());
        this.versionConfig = new VersionConfig((Plugin)this, this.versionFetcher);
        this.fancyAnalytics = new FancyAnalyticsAPI("ca2baf32-1fd2-4baa-a38a-f12ed8ab24a4", "Y7EP2jJjYWExZjdmMDkwNTQ5ZmRbIGUI");
        this.fancyAnalytics.getConfig().setDisableLogging(true);
        this.featureFlagConfig = new FeatureFlagConfig((Plugin)this);
    }

    public static FancyNpcs getInstance() {
        return instance;
    }

    public void onLoad() {
        String mcVersion;
        this.featureFlagConfig.addFeatureFlag(PLAYER_NPCS_FEATURE_FLAG);
        this.featureFlagConfig.addFeatureFlag(USE_NATIVE_THREADS_FEATURE_FLAG);
        this.featureFlagConfig.addFeatureFlag(ENABLE_DEBUG_MODE_FEATURE_FLAG);
        this.featureFlagConfig.addFeatureFlag(ENABLE_FOLIA_VISIBILITY_FIX_FEATURE_FLAG);
        this.featureFlagConfig.addFeatureFlag(USE_MINECRAFT_USERCACHE_FEATURE_FLAG);
        this.featureFlagConfig.load();
        if (ENABLE_DEBUG_MODE_FEATURE_FLAG.isEnabled()) {
            this.fancyLogger.setCurrentLevel(LogLevel.DEBUG);
        }
        switch (mcVersion = Bukkit.getMinecraftVersion()) {
            case "1.21.11": {
                this.npcAdapter = Npc_1_21_11::new;
                break;
            }
            case "1.21.9": 
            case "1.21.10": {
                this.npcAdapter = Npc_1_21_9::new;
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                this.npcAdapter = Npc_1_21_6::new;
                break;
            }
            case "1.21.5": {
                this.npcAdapter = Npc_1_21_5::new;
                break;
            }
            case "1.21.4": {
                this.npcAdapter = Npc_1_21_4::new;
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                this.npcAdapter = Npc_1_21_3::new;
                break;
            }
            case "1.21": 
            case "1.21.1": {
                this.npcAdapter = Npc_1_21_1::new;
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                this.npcAdapter = Npc_1_20_6::new;
                break;
            }
            case "1.20.3": 
            case "1.20.4": {
                this.npcAdapter = Npc_1_20_4::new;
                break;
            }
            case "1.20.2": {
                this.npcAdapter = Npc_1_20_2::new;
                break;
            }
            case "1.20.1": 
            case "1.20": {
                this.npcAdapter = Npc_1_20_1::new;
                break;
            }
            case "1.19.4": {
                this.npcAdapter = Npc_1_19_4::new;
                break;
            }
            default: {
                this.npcAdapter = null;
            }
        }
        this.npcManager = new NpcManagerImpl(this, this.npcAdapter);
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.npcAdapter == null) {
            this.fancyAnalytics.sendEvent(new Event("pluginLoadingWithUnsupportedVersion", new HashMap<String, String>()).withProperty("version", mcVersion).withProperty("pluginVersion", this.getPluginMeta().getVersion()));
            this.fancyLogger.error("Unsupported minecraft server version.", new Property[0]);
            this.getLogger().warning("--------------------------------------------------");
            this.getLogger().warning("Unsupported minecraft server version.");
            this.getLogger().warning("This plugin only supports 1.19.4 - 1.21.11");
            this.getLogger().warning("Disabling the FancyNpcs plugin.");
            this.getLogger().warning("--------------------------------------------------");
            pluginManager.disablePlugin((Plugin)this);
            return;
        }
    }

    public void onEnable() {
        if (this.npcAdapter == null) {
            return;
        }
        new FancyLib(instance);
        String mcVersion = Bukkit.getMinecraftVersion();
        this.config.reload();
        this.attributeManager = new AttributeManagerImpl();
        this.actionManager = new ActionManagerImpl();
        this.actionManager.registerAction(new MessageAction());
        this.actionManager.registerAction(new PlayerCommandAction());
        this.actionManager.registerAction(new PlayerCommandAsOpAction());
        this.actionManager.registerAction(new ConsoleCommandAction());
        this.actionManager.registerAction(new SendToServerAction());
        this.actionManager.registerAction(new WaitAction());
        this.actionManager.registerAction(new ExecuteRandomActionAction());
        this.actionManager.registerAction(new BlockUntilDoneAction());
        this.actionManager.registerAction(new NeedPermissionAction());
        this.actionManager.registerAction(new PlaySoundAction());
        this.skinManager = new SkinManagerImpl(new UUIDFileCache(), new SkinCacheFile(), new SkinCacheMemory(), MojangQueue.get(), MineSkinQueue.get());
        OldSkinCacheMigrator.migrate();
        this.textConfig = new TextConfig("#E33239", "#AD1D23", "#81E366", "#E3CA66", "#E36666", "");
        this.translator = new Translator(this.textConfig);
        this.translator.loadLanguages(this.getDataFolder().getAbsolutePath());
        Language selectedLanguage = this.translator.getLanguages().stream().filter(language -> language.getLanguageName().equals(this.config.getLanguage())).findFirst().orElse(this.translator.getFallbackLanguage());
        this.translator.setSelectedLanguage(selectedLanguage);
        this.versionConfig.load();
        ComparableVersion currentVersion = new ComparableVersion(this.versionConfig.getVersion());
        ((CompletableFuture)CompletableFuture.supplyAsync(this.getVersionFetcher()::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(currentVersion) <= 0) {
                return;
            }
            this.fancyLogger.warn("You are not using the latest version of the FancyNpcs plugin.", new Property[0]);
            this.getLogger().warning("\n-------------------------------------------------------\nYou are not using the latest version of the FancyNpcs plugin.\nPlease update to the newest version (%s).\n%s\n-------------------------------------------------------\n".formatted(newest, this.getVersionFetcher().getDownloadUrl()));
        });
        if (!ServerSoftware.isPaper()) {
            this.fancyLogger.warn("You are not using Paper as server software.", new Property[0]);
            this.getLogger().warning("--------------------------------------------------");
            this.getLogger().warning("It is recommended to use Paper as server software.");
            this.getLogger().warning("Because you are not using paper, the plugin");
            this.getLogger().warning("might not work correctly.");
            this.getLogger().warning("--------------------------------------------------");
        }
        this.registerMetrics();
        this.checkIfPluginVersionUpdated();
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.usingPlotSquared = pluginManager.isPluginEnabled("PlotSquared");
        pluginManager.registerEvents((Listener)new PlayerJoinListener(), (Plugin)instance);
        pluginManager.registerEvents((Listener)new PlayerQuitListener(), (Plugin)instance);
        pluginManager.registerEvents((Listener)new PlayerTeleportListener(), (Plugin)instance);
        pluginManager.registerEvents((Listener)new PlayerChangedWorldListener(), (Plugin)instance);
        pluginManager.registerEvents((Listener)this.skinManager, (Plugin)instance);
        if (Set.of("1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10", "1.21.11").contains(Bukkit.getMinecraftVersion())) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoadedListener(), (Plugin)this);
        }
        switch (mcVersion) {
            case "1.19.4": {
                pluginManager.registerEvents((Listener)new PacketReader_1_19_4(), (Plugin)instance);
                break;
            }
            case "1.20": {
                pluginManager.registerEvents((Listener)new PacketReader_1_20(), (Plugin)instance);
                break;
            }
            default: {
                pluginManager.registerEvents((Listener)new PlayerUseUnknownEntityListener(), (Plugin)instance);
            }
        }
        if (PLAYER_NPCS_FEATURE_FLAG.isEnabled()) {
            pluginManager.registerEvents((Listener)new PlayerNpcsListener(), (Plugin)instance);
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.scheduler.runTaskLater(null, 100L, () -> this.npcManager.loadNpcs());
        this.visibilityTracker = new VisibilityTracker();
        this.npcThread.scheduleAtFixedRate(new TurnToPlayerTracker(), 0L, 50L, TimeUnit.MILLISECONDS);
        this.npcThread.scheduleAtFixedRate(this.visibilityTracker, 0L, (long)this.config.getNpcUpdateVisibilityInterval() * 50L, TimeUnit.MILLISECONDS);
        int autosaveInterval = this.config.getAutoSaveInterval();
        if (this.config.isEnableAutoSave() && this.config.getAutoSaveInterval() > 0) {
            this.scheduler.runTaskTimerAsynchronously(1200L, (long)autosaveInterval * 60L * 20L, () -> this.npcManager.saveNpcs(false));
        }
        int npcUpdateInterval = this.config.getNpcUpdateInterval();
        this.npcThread.scheduleAtFixedRate(() -> {
            ArrayList<Npc> npcs = new ArrayList<Npc>(this.npcManager.getAllNpcs());
            for (Npc npc : npcs) {
                try {
                    String skinID;
                    boolean shouldUpdate = false;
                    if (npc.getData().getDisplayName() != null && !npc.getData().getDisplayName().isBlank() && SkinUtils.isPlaceholder(npc.getData().getDisplayName())) {
                        shouldUpdate = true;
                    }
                    if (npc.getData().getSkinData() != null && !(skinID = npc.getData().getSkinData().getIdentifier()).isEmpty() && SkinUtils.isPlaceholder(skinID)) {
                        SkinData skinData = this.skinManager.getByIdentifier(skinID, npc.getData().getSkinData().getVariant());
                        skinData.setIdentifier(skinID);
                        npc.getData().setSkinData(skinData);
                        shouldUpdate = true;
                    }
                    if (!shouldUpdate) continue;
                    npc.removeForAll();
                    npc.create();
                    npc.spawnForAll();
                }
                catch (Throwable thr) {
                    this.fancyLogger.error("An error occurred while updating '" + npc.getData().getName() + "' NPC.", ThrowableProperty.of(thr));
                }
            }
        }, 30L, npcUpdateInterval, TimeUnit.SECONDS);
        if (this.config.isRegisterCommands()) {
            this.commandManager = new CloudCommandManager(this, false).registerArguments().registerExceptionHandlers().registerCommands();
        } else {
            this.getLogger().warning("Commands and related components have not been registered. This can be changed by setting 'register_commands' to true, and restarting the server.");
        }
        if (ENABLE_DEBUG_MODE_FEATURE_FLAG.isEnabled() && Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            PlaceholderApiEnv.registerPlaceholders();
        }
        this.fancyLogger.info("FancyNpcs (" + this.versionConfig.getVersion() + ") has been enabled.", new Property[0]);
    }

    public void onDisable() {
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        if (this.npcManager != null) {
            this.npcManager.saveNpcs(true);
        }
        this.fancyLogger.info("FancyNpcs has been disabled.", new Property[0]);
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics(this, 17543);
        metrics.addCustomChart(new Metrics.SingleLineChart("total_npcs", () -> this.npcManager.getAllNpcs().size()));
        metrics.addCustomChart(new Metrics.SimplePie("update_notifications", () -> this.config.isMuteVersionNotification() ? "No" : "Yes"));
        metrics.addCustomChart(new Metrics.SimplePie("using_development_build", () -> this.versionConfig.isDevelopmentBuild() ? "Yes" : "No"));
        this.fancyAnalytics.registerMinecraftPluginMetrics((Plugin)instance);
        this.fancyAnalytics.getExceptionHandler().registerLogger(this.getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(Bukkit.getLogger());
        this.fancyAnalytics.getExceptionHandler().registerLogger(this.fancyLogger);
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("commit_hash", () -> this.versionConfig.getCommitHash().substring(0, 7)));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("server_size", () -> {
            long onlinePlayers = Bukkit.getOnlinePlayers().size();
            if (onlinePlayers == 0L) {
                return "empty";
            }
            if (onlinePlayers <= 25L) {
                return "small";
            }
            if (onlinePlayers <= 100L) {
                return "medium";
            }
            if (onlinePlayers <= 500L) {
                return "large";
            }
            return "very_large";
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_npcs", () -> this.npcManager.getAllNpcs().size()));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("enabled_update_notifications", () -> this.config.isMuteVersionNotification() ? "false" : "true"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("enabled_player_npcs_fflag", () -> PLAYER_NPCS_FEATURE_FLAG.isEnabled() ? "true" : "false"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("using_development_build", () -> this.versionConfig.isDevelopmentBuild() ? "true" : "false"));
        this.fancyAnalytics.registerStringMetric(new MetricSupplier<String>("language", () -> this.translator.getSelectedLanguage().getLanguageCode()));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("avg_interaction_cooldown", () -> {
            double sum = 0.0;
            int count = 0;
            for (Npc npc : this.npcManager.getAllNpcs()) {
                if (!(npc.getData().getInteractionCooldown() > 0.0f)) continue;
                sum += (double)npc.getData().getInteractionCooldown();
                ++count;
            }
            if (count == 0) {
                return 0.0;
            }
            return sum / (double)count;
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_npcs_interaction_cooldown_longer_than_5min", () -> {
            long count = this.npcManager.getAllNpcs().stream().filter(npc -> npc.getData().getInteractionCooldown() > 300.0f).count();
            return count;
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_non_persistent_npcs", () -> {
            long count = this.npcManager.getAllNpcs().stream().filter(npc -> !npc.isSaveToFile()).count();
            return count;
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_not_player_npcs", () -> {
            long count = this.npcManager.getAllNpcs().stream().filter(npc -> npc.getData().getType() != EntityType.PLAYER).count();
            return count;
        }));
        this.fancyAnalytics.registerStringArrayMetric(new MetricSupplier<String[]>("npc_type", () -> (String[])this.npcManager.getAllNpcs().stream().map(npc -> npc.getData().getType().name()).toArray(String[]::new)));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_npcs_having_attributes", () -> {
            long count = this.npcManager.getAllNpcs().stream().filter(npc -> !npc.getData().getAttributes().isEmpty()).count();
            return count;
        }));
        this.fancyAnalytics.registerNumberMetric(new MetricSupplier<Double>("amount_npc_actions", () -> {
            long count = 0L;
            for (Npc npc : this.npcManager.getAllNpcs()) {
                count += (long)npc.getData().getActions().values().size();
            }
            return count;
        }));
        this.fancyAnalytics.initialize();
    }

    private void checkIfPluginVersionUpdated() {
        String currentVersion = this.versionConfig.getVersion();
        String lastVersion = "N/A";
        File versionFile = new File(this.getDataFolder(), "version.yml");
        if (!versionFile.exists()) {
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.fancyLogger.warn("Could not write version file.", new Property[0]);
                return;
            }
        }
        try {
            lastVersion = new String(Files.readAllBytes(versionFile.toPath()));
        }
        catch (IOException e) {
            this.fancyLogger.warn("Could not read version file.", new Property[0]);
            return;
        }
        if (!lastVersion.equals(currentVersion)) {
            this.fancyLogger.info("Plugin has been updated from version " + lastVersion + " to " + currentVersion + ".", new Property[0]);
            this.fancyAnalytics.sendEvent(new Event("PluginVersionUpdated", new HashMap<String, String>()).withProperty("from", lastVersion).withProperty("to", currentVersion).withProperty("commit_hash", this.versionConfig.getCommitHash()).withProperty("channel", this.versionConfig.getChannel()).withProperty("platform", this.versionConfig.getPlatform()));
            try {
                Files.write(versionFile.toPath(), currentVersion.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.fancyLogger.warn("Could not write version file.", new Property[0]);
            }
        }
    }

    @Override
    public Thread newThread(String name, Runnable runnable) {
        if (USE_NATIVE_THREADS_FEATURE_FLAG.isEnabled()) {
            return new Thread(runnable, name);
        }
        return Thread.ofVirtual().name(name).unstarted(runnable);
    }

    @Override
    public ExtendedFancyLogger getFancyLogger() {
        return this.fancyLogger;
    }

    @Override
    public ScheduledExecutorService getNpcThread() {
        return this.npcThread;
    }

    @Override
    public Function<NpcData, Npc> getNpcAdapter() {
        return this.npcAdapter;
    }

    @Override
    public FancyScheduler getScheduler() {
        return this.scheduler;
    }

    public NpcManagerImpl getNpcManagerImpl() {
        return this.npcManager;
    }

    @Override
    public NpcManager getNpcManager() {
        return this.npcManager;
    }

    @Override
    public AttributeManagerImpl getAttributeManager() {
        return this.attributeManager;
    }

    @Override
    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    public SkinManagerImpl getSkinManagerImpl() {
        return this.skinManager;
    }

    @Override
    public ActionManagerImpl getActionManager() {
        return this.actionManager;
    }

    @Override
    public FancyNpcsConfigImpl getFancyNpcConfig() {
        return this.config;
    }

    public VersionConfig getVersionConfig() {
        return this.versionConfig;
    }

    public CloudCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public Translator getTranslator() {
        return this.translator;
    }

    public TextConfig getTextConfig() {
        return this.textConfig;
    }

    @Override
    public FeatureFlagConfig getFeatureFlagConfig() {
        return this.featureFlagConfig;
    }

    public VersionFetcher getVersionFetcher() {
        return this.versionFetcher;
    }

    public FancyAnalyticsAPI getFancyAnalytics() {
        return this.fancyAnalytics;
    }

    public VisibilityTracker getVisibilityTracker() {
        return this.visibilityTracker;
    }

    public boolean isUsingPlotSquared() {
        return this.usingPlotSquared;
    }

    @Override
    public JavaPlugin getPlugin() {
        return instance;
    }
}

