/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.api.actions.types;

import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.api.actions.executor.ActionExecutionContext;
import org.jetbrains.annotations.NotNull;

public class WaitAction
extends NpcAction {
    public WaitAction() {
        super("wait", true);
    }

    @Override
    public void execute(@NotNull ActionExecutionContext context, String value) {
        int time;
        if (value == null || value.isEmpty()) {
            return;
        }
        try {
            time = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            FancyNpcsPlugin.get().getFancyLogger().warn("Invalid time value for wait action: " + value, new Property[0]);
            return;
        }
        try {
            Thread.sleep((long)time * 1000L);
        }
        catch (InterruptedException e) {
            FancyNpcsPlugin.get().getFancyLogger().warn("Thread was interrupted while waiting", new Property[0]);
        }
    }
}

