/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.arguments;

import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.actions.NpcAction;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class ActionTypeArgument {
    public static final ActionTypeArgument INSTANCE = new ActionTypeArgument();
    private static final FancyNpcs PLUGIN = FancyNpcs.getInstance();
    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    private ActionTypeArgument() {
    }

    @Parser(name="", suggestions="action_type")
    public NpcAction parse(CommandContext<CommandSender> context, CommandInput input) {
        String value = input.readString();
        @Nullable NpcAction action = PLUGIN.getActionManager().getActionByName(value);
        if (action == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_action_type").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return action;
    }

    @Suggestions(value="action_type")
    public Iterable<String> suggestions(CommandContext<CommandSender> context, CommandInput input) {
        return PLUGIN.getActionManager().getAllActions().stream().map(NpcAction::getName).toList();
    }
}

