/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.arguments;

import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public enum LocationArgument {
    INSTANCE;

    private static final DecimalFormat COORDS_FORMAT;

    @Suggestions(value="relative_location")
    public List<String> suggestLocation(CommandContext<CommandSender> context, CommandInput input) {
        CommandSender commandSender = context.sender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            @Nullable RayTraceResult raytrace = player.rayTraceBlocks(32.0, FluidCollisionMode.ALWAYS);
            if (raytrace != null) {
                return List.of(COORDS_FORMAT.format(raytrace.getHitPosition().getX()) + " " + COORDS_FORMAT.format(raytrace.getHitPosition().getY()) + " " + COORDS_FORMAT.format(raytrace.getHitPosition().getZ()), "~ ~ ~");
            }
            return List.of("~ ~ ~");
        }
        return Collections.emptyList();
    }

    static {
        COORDS_FORMAT = new DecimalFormat("#.##");
    }
}

