/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.arguments;

import de.oliver.cloud.annotations.parser.Parser;
import de.oliver.cloud.annotations.suggestion.Suggestions;
import de.oliver.cloud.context.CommandContext;
import de.oliver.cloud.context.CommandInput;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcManager;
import de.oliver.fancynpcs.commands.exceptions.ReplyingParseException;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.units.qual.C;
import org.jetbrains.annotations.NotNull;

public class NpcArgument {
    public static final NpcArgument INSTANCE = new NpcArgument();
    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private final NpcManager npcManager = FancyNpcs.getInstance().getNpcManager();

    private NpcArgument() {
    }

    private static boolean isUUID(@NotNull String string) {
        try {
            UUID.fromString(string);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Parser(name="", suggestions="npc")
    @NotNull
    public Npc parse(CommandContext<CommandSender> context, CommandInput input) {
        Npc npc;
        CommandSender commandSender;
        String value = input.readString();
        if (FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled() && (commandSender = context.sender()) instanceof Player) {
            Player playerSender = (Player)commandSender;
            npc = this.npcManager.getNpc(value, playerSender.getUniqueId());
        } else {
            npc = NpcArgument.isUUID(value) ? this.npcManager.getNpcById(value) : this.npcManager.getNpc(value);
        }
        if (npc == null) {
            throw ReplyingParseException.replying(() -> this.translator.translate("command_invalid_npc").replaceStripped("input", value).send((CommandSender)context.sender()));
        }
        return npc;
    }

    @Suggestions(value="npc")
    public List<String> suggestions(CommandContext<C> context, CommandInput input) {
        C c;
        if (FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled() && (c = context.sender()) instanceof Player) {
            Player playerSender = (Player)c;
            return this.npcManager.getAllNpcs().stream().filter(npc -> npc.getData().getCreator().equals(playerSender.getUniqueId())).map(npc -> npc.getData().getName()).toList();
        }
        return this.npcManager.getAllNpcs().stream().map(npc -> npc.getData().getName()).toList();
    }
}

