/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Flag;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.events.NpcCreateEvent;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CreateCMD {
    INSTANCE;

    private static final Pattern NPC_NAME_PATTERN;
    private static final UUID EMPTY_UUID;
    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc create <name>")
    @Permission(value={"fancynpcs.command.npc.create"})
    public void onCreate(@NotNull CommandSender sender, @NotNull String name, @Flag(value="type") @Nullable EntityType type, @Flag(value="location", suggestions="relative_location") @Nullable Location location, @Flag(value="world") @Nullable World world) {
        Location finalLocation;
        UUID creator;
        if (!NPC_NAME_PATTERN.matcher(name).find()) {
            this.translator.translate("npc_create_failure_invalid_name").replaceStripped("name", name).send(sender);
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            v0 = player.getUniqueId();
        } else {
            v0 = creator = EMPTY_UUID;
        }
        if (FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled() && FancyNpcs.getInstance().getNpcManager().getNpc(name, creator) != null || !FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled() && FancyNpcs.getInstance().getNpcManager().getNpc(name) != null) {
            this.translator.translate("npc_create_failure_already_exists").replace("npc", FancyNpcs.getInstance().getNpcManager().getNpc(name).getData().getName()).send(sender);
            return;
        }
        if (sender instanceof ConsoleCommandSender && location == null) {
            this.translator.translate("npc_create_failure_must_specify_location").send(sender);
            return;
        }
        if (sender instanceof ConsoleCommandSender && world == null) {
            this.translator.translate("npc_create_failure_must_specify_world").send(sender);
            return;
        }
        if (location == null && sender instanceof Player) {
            Player player = (Player)sender;
            v1 = player.getLocation();
        } else {
            v1 = finalLocation = location;
        }
        if (world != null) {
            finalLocation.setWorld(world);
        }
        Npc npc = FancyNpcs.getInstance().getNpcAdapter().apply(new NpcData(name, creator, finalLocation));
        npc.getData().setType(type != null ? type : EntityType.PLAYER);
        if (new NpcCreateEvent(npc, sender).callEvent()) {
            npc.create();
            FancyNpcs.getInstance().getNpcManagerImpl().registerNpc(npc);
            npc.spawnForAll();
            this.translator.translate("npc_create_success").replace("npc", name).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }

    static {
        NPC_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9/_-]*$");
        EMPTY_UUID = new UUID(0L, 0L);
    }
}

