/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public enum TeleportCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc teleport <npc>", requiredSender=Player.class)
    @Permission(value={"fancynpcs.command.npc.teleport"})
    public void onTeleport(@NotNull Player sender, @NotNull Npc npc) {
        Location location = npc.getData().getLocation();
        if (location.getWorld() == null) {
            this.translator.translate("npc_teleport_failure_world_not_loaded").send((CommandSender)sender);
            return;
        }
        sender.teleportAsync(location).whenComplete((isSuccess, thr) -> {
            this.translator.translate(isSuccess != false ? "npc_teleport_success" : "npc_teleport_failure_exception").replace("npc", npc.getData().getName()).send((CommandSender)sender);
            if (thr != null) {
                thr.printStackTrace();
            }
        });
    }
}

