/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.libs.chatcolorhandler.parsers.custom;

import de.oliver.fancynpcs.libs.chatcolorhandler.messengers.MiniMessageMessenger;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Parser;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.Resolver;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MiniMessagePlaceholderParser
implements Resolver {
    public static final MiniMessagePlaceholderParser INSTANCE = new MiniMessagePlaceholderParser();
    private static final TagResolver VANILLA_PLACEHOLDERS = TagResolver.builder().resolvers(new TagResolver[]{StandardTags.keybind(), StandardTags.translatable(), StandardTags.translatableFallback(), StandardTags.selector(), StandardTags.score(), StandardTags.nbt()}).build();

    private MiniMessagePlaceholderParser() {
    }

    @Override
    public String getType() {
        return "placeholder";
    }

    @Override
    public String parseString(@NotNull String string, @NotNull Parser.OutputType outputType) {
        return switch (outputType) {
            default -> throw new MatchException(null, null);
            case Parser.OutputType.SPIGOT -> {
                string = string.replace('\u00a7', '&');
                yield MiniMessageMessenger.LEGACY_COMPONENT_SERIALIZER.serialize(MiniMessageMessenger.MINI_MESSAGE.deserialize(string, VANILLA_PLACEHOLDERS));
            }
            case Parser.OutputType.MINI_MESSAGE -> string;
        };
    }

    @Override
    @NotNull
    public TagResolver getResolver() {
        return VANILLA_PLACEHOLDERS;
    }
}

