/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins.mojang;

import com.google.gson.Gson;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.skins.SkinData;
import de.oliver.fancynpcs.skins.mineskin.RatelimitException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executor;

public class MojangAPI {
    private final HttpClient client;
    private final Gson gson = new Gson();

    public MojangAPI(Executor executor) {
        this.client = HttpClient.newBuilder().connectTimeout(Duration.of(3L, ChronoUnit.SECONDS)).executor(executor).build();
    }

    public SkinData fetchSkin(String uuid, SkinData.SkinVariant variant) throws RatelimitException {
        FancyNpcsPlugin.get().getFancyLogger().debug("Fetching skin from MojangAPI for " + uuid, new Property[0]);
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false")).GET().build();
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
                FancyNpcsPlugin.get().getFancyLogger().warn("Failed to fetch skin from Mojang API for " + uuid + " (status code: " + resp.statusCode() + ")", new Property[0]);
                FancyNpcsPlugin.get().getFancyLogger().debug("Body: " + resp.body(), new Property[0]);
                return null;
            }
            if (resp.statusCode() == 429) {
                throw new RatelimitException(System.currentTimeMillis() + 10000L);
            }
            RequestResponse response = this.gson.fromJson(resp.body(), RequestResponse.class);
            RequestResponseProperty textures = response.getProperty("textures");
            FancyNpcsPlugin.get().getFancyLogger().debug("Skin fetched from MojangAPI for " + uuid, new Property[0]);
            return new SkinData(uuid, variant, textures.value(), textures.signature());
        }
        catch (RatelimitException e) {
            throw e;
        }
        catch (Exception e) {
            FancyNpcsPlugin.get().getFancyLogger().warn("Failed to fetch skin from Mojang API for " + uuid, ThrowableProperty.of(e));
            return null;
        }
    }

    record RequestResponse(String id, String name, RequestResponseProperty[] properties) {
        public RequestResponseProperty getProperty(String name) {
            for (RequestResponseProperty property : this.properties) {
                if (!property.name.equals(name)) continue;
                return property;
            }
            return null;
        }
    }

    record RequestResponseProperty(String name, String value, String signature) {
    }
}

