/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.tests.api;

import de.oliver.fancynpcs.libs.chatcolorhandler.ChatColorHandler;
import de.oliver.fancynpcs.libs.chatcolorhandler.parsers.ParserTypes;
import de.oliver.plugintests.annotations.FPTest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatColorHandlerTest {
    @FPTest(name="Test Placeholders")
    public void testPlaceholders(Player player) {
        if (!this.isPlaceholderAPIEnabled()) {
            return;
        }
        String input = "Player name: %fn-test%";
        String got = ChatColorHandler.translate(input, player, ParserTypes.placeholder());
        String expected = "Player name: ";
        if (got.equalsIgnoreCase("Player name: %fn-test%")) {
            throw new AssertionError((Object)("Placeholder not replaced: " + got));
        }
    }

    private boolean isPlaceholderAPIEnabled() {
        Plugin placeholderAPI = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        return placeholderAPI != null && placeholderAPI.isEnabled();
    }
}

