/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_6.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_6.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;

public class VillagerAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("profession", Arrays.stream(Villager.Profession.values()).map(Enum::name).toList(), List.of(EntityType.VILLAGER), VillagerAttributes::setProfession));
        attributes.add(new NpcAttribute("type", Arrays.stream(Villager.Type.values()).map(Enum::name).toList(), List.of(EntityType.VILLAGER), VillagerAttributes::setType));
        return attributes;
    }

    private static void setProfession(Npc npc, String value) {
        Villager villager = (Villager)ReflectionHelper.getEntity(npc);
        villager.setVillagerData(villager.getVillagerData().setProfession(switch (value.toUpperCase()) {
            case "ARMORER" -> VillagerProfession.ARMORER;
            case "BUTCHER" -> VillagerProfession.BUTCHER;
            case "CARTOGRAPHER" -> VillagerProfession.CARTOGRAPHER;
            case "CLERIC" -> VillagerProfession.CLERIC;
            case "FARMER" -> VillagerProfession.FARMER;
            case "FISHERMAN" -> VillagerProfession.FISHERMAN;
            case "FLETCHER" -> VillagerProfession.FLETCHER;
            case "LEATHERWORKER" -> VillagerProfession.LEATHERWORKER;
            case "LIBRARIAN" -> VillagerProfession.LIBRARIAN;
            case "MASON" -> VillagerProfession.MASON;
            case "NITWIT" -> VillagerProfession.NITWIT;
            case "SHEPHERD" -> VillagerProfession.SHEPHERD;
            case "TOOLSMITH" -> VillagerProfession.TOOLSMITH;
            case "WEAPONSMITH" -> VillagerProfession.WEAPONSMITH;
            default -> VillagerProfession.NONE;
        }));
    }

    private static void setType(Npc npc, String value) {
        Villager villager = (Villager)ReflectionHelper.getEntity(npc);
        villager.setVillagerData(villager.getVillagerData().setType(switch (value.toUpperCase()) {
            case "DESERT" -> VillagerType.DESERT;
            case "JUNGLE" -> VillagerType.JUNGLE;
            case "SAVANNA" -> VillagerType.SAVANNA;
            case "SNOW" -> VillagerType.SNOW;
            case "SWAMP" -> VillagerType.SWAMP;
            case "TAIGA" -> VillagerType.TAIGA;
            default -> VillagerType.PLAINS;
        }));
    }
}

