/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_11.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_11.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.item.DyeColor;
import org.bukkit.entity.EntityType;

public class CatAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", CatAttributes.getCatVariantRegistry().listElementIds().map(id -> id.identifier().getPath()).toList(), List.of(EntityType.CAT), CatAttributes::setVariant));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sleeping", "sitting"), List.of(EntityType.CAT), CatAttributes::setPose));
        attributes.add(new NpcAttribute("collar_color", List.of("RED", "BLUE", "YELLOW", "GREEN", "PURPLE", "ORANGE", "LIME", "MAGENTA", "BROWN", "WHITE", "GRAY", "LIGHT_GRAY", "LIGHT_BLUE", "BLACK", "CYAN", "PINK", "NONE"), List.of(EntityType.CAT), CatAttributes::setCollarColor));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        Cat cat = (Cat)ReflectionHelper.getEntity(npc);
        Holder variant = (Holder)CatAttributes.getCatVariantRegistry().get(ResourceKey.create((ResourceKey)Registries.CAT_VARIANT, (Identifier)Identifier.withDefaultNamespace((String)value.toLowerCase()))).orElseThrow();
        cat.setVariant(variant);
    }

    private static void setPose(Npc npc, String value) {
        Cat cat = (Cat)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                cat.setInSittingPose(false, false);
                cat.setLying(false);
                break;
            }
            case "sleeping": {
                cat.setInSittingPose(false, false);
                cat.setLying(true);
                break;
            }
            case "sitting": {
                cat.setLying(false);
                cat.setOrderedToSit(true);
                cat.setInSittingPose(true, false);
            }
        }
    }

    private static HolderLookup.RegistryLookup<CatVariant> getCatVariantRegistry() {
        return MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.CAT_VARIANT);
    }

    private static void setCollarColor(Npc npc, String value) {
        Cat cat = (Cat)ReflectionHelper.getEntity(npc);
        if (value.equalsIgnoreCase("none") || value.isEmpty()) {
            cat.setTame(false, false);
            return;
        }
        try {
            DyeColor color = DyeColor.valueOf((String)value.toUpperCase());
            if (!cat.isTame()) {
                cat.setTame(true, false);
            }
            cat.setCollarColor(color);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid cat collar color: " + value);
        }
    }
}

